<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">
    
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
	<xsl:template name="common-content-richtext-field">
		<xsl:param name="value"/>
		<xsl:param name="title"/>
		<xsl:param name="level"/>
		
		<xsl:if test="cms:isNotRichTextEmpty($value)">
            <xsl:if test="normalize-space($title) != ''">
            	<xsl:element name="h{$level}">
    	            <i18n:text>
    	                <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($title,':')" /></xsl:attribute>
    	                <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($title,':')" /></xsl:attribute>                    
    	            </i18n:text>         
    	        </xsl:element>
            </xsl:if>
            
			<xsl:apply-templates select="$value/docbook:article">
				<xsl:with-param name="level" select="$level + 1"/>
			</xsl:apply-templates>                  
		</xsl:if>	
	</xsl:template>
	
	<xsl:template match="items">
	</xsl:template>
    
    <!-- Utilisé pour les champs contenus dans le bloc brief -->
    <xsl:template name="common-content-odf-brief-field">
        <xsl:param name="label"/>
        <xsl:param name="value"/>
        
        <div class="item">
            <xsl:if test="normalize-space($label) != ''">
                <strong>
                    <i18n:text>
                        <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($label,':')" /></xsl:attribute>
                        <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($label,':')" /></xsl:attribute>                    
                    </i18n:text>
                    <xsl:text> : </xsl:text>
                </strong>       
            </xsl:if>
            <span><xsl:value-of select="$value"/></span>
        </div>
    </xsl:template>

</xsl:stylesheet>
