<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:math="http://exslt.org/math" 
                              xmlns:filename="org.ametys.core.util.FilenameUtils"
                              exclude-result-prefixes="docbook resolver math exsl ametys filename"
                              extension-element-prefixes="cms">
    
    <!-- FIXME CMS-8956 workaround -->
    <xsl:import href="view:cms://stylesheets/content/common.xsl"/>
	<xsl:import href="plugin:odf://stylesheets/content/common.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">program</xsl:variable>
    
    <xsl:variable name="programId" select="/view/content/@id"/>
    <xsl:variable name="uniqueId" select="concat('program_', substring-after(math:random(), '.'))"/>
    
    <xsl:variable name="contextPath" select="ametys:uriPrefix()"/>
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 

    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title">
        <xsl:call-template name="common-content-body-title-content"/>
    </xsl:template>
    
	<xsl:template name="pdf-download">
		<a onclick="window.open(this.href); return false;" class="pdf-download" title="plugin.odf:CONTENT_PROGRAM_PDF_DOWNLOAD_ALT" i18n:attr="title" href="{$contextPath}/plugins/odf/_content/{/view/content/@name}/{filename:filterName(/view/content/@title)}.pdf">
			<i18n:text i18n:key="CONTENT_PROGRAM_PDF_DOWNLOAD"/>
		</a>
	</xsl:template>
	
</xsl:stylesheet>
