<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="i18n resolver">
    
    <xsl:import href="view:cms://stylesheets/properties/content/referencer.xsl"/>
    
    <xsl:template match="/ActionResult">
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl:template match="educationalPaths">
        <xsl:if test="educationalPaths">
            <div class="bloc">
                <h1><i18n:text i18n:key="UITOOL_DETAILS_PROGRAMITEM_EDUCATIONAL_PATH" i18n:catalogue="plugin.odf"/></h1>
                <ul>
                    <xsl:apply-templates select="educationalPaths" mode="path"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="educationalPaths" mode="path">
        <li>
            <xsl:apply-templates select="educationalPaths" mode="item"/>
        </li>
    </xsl:template>
    
    <xsl:template match="educationalPaths[position() = last()]" mode="item">
        <xsl:value-of select="title"/> (<xsl:value-of select="code"/>)
    </xsl:template>
    
    <xsl:template match="educationalPaths" mode="item">
        <a href="{resolver:resolve('content', id)}"><xsl:value-of select="title"/> (<xsl:value-of select="code"/>)</a>
        <xsl:text> &gt; </xsl:text>
    </xsl:template>
    
    <xsl:template match="children">
        <xsl:if test="children">
            <div class="bloc">
                <h1><i18n:text i18n:key="UITOOL_DETAILS_PROGRAMITEM_CHILDREN" i18n:catalogue="plugin.odf"/></h1>
                <ul>
                    <xsl:apply-templates select="children" mode="item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="children" mode="item">
        <li>
             <a href="{resolver:resolve('content', id)}"><xsl:value-of select="title"/> (<xsl:value-of select="code"/>)</a>
        </li>
    </xsl:template>
    
    <xsl:template match="otherReferences">
        <xsl:if test="referencingContents/referencingContents">
            <div class="bloc">
                <h1><i18n:text i18n:key="UITOOL_DETAILS_PROGRAMITEM_OTHER_REFERENCING_CONTENTS" i18n:catalogue="plugin.odf"/></h1>
                <xsl:apply-templates select="*"/>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
