/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one or more micro skills from a macro skill.<br>
 * This embeds a drop down list with querying on title of micro skills and type-ahead support.<br> 
 * Allow content creation using #cfg-allowCreation.<br>
 * 
 * This widget is used to select micro skills in a macro skill edit.
 */
Ext.define('Ametys.odf.widget.SelectMicroFromMacroSkills', {
    extend: 'Ametys.cms.form.widget.SelectContent',
    
    constructor: function (config)
    {
        // Get the root content path (needed for creation)
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.skill.ODFSkillsHelper",
            methodName: "getOdfRootContentPath",
            callback: {
                handler: this._setRootContentPathCb,
                scope: this
            },
            errorMessage:true,
            waitMessage: false
        });
        
        this._parentMacroSkill = config.contentInfo.contentId;
        // Get the catalog of the current content (needed for creation)
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.skill.ODFSkillsHelper",
            methodName: "getCatalog",
            parameters: [this._parentMacroSkill],
            callback: {
                handler: this._setContentCatalogCb,
                scope: this
            },
            errorMessage:true,
            waitMessage: false
        });
        
        this.callParent(arguments);
    },
    
    /**
     * Set the current content catalog.
     * @param {String} rootContentPath The rootContentPath
     * @private
     */
    _setRootContentPathCb: function(rootContentPath)
    {
        this._rootContentPath = rootContentPath;
    },
    
    /**
     * Set the current content catalog.
     * @param {String} catalogName The catalog name
     * @private
     */
    _setContentCatalogCb: function(catalogName)
    {
        this._contentCatalog = catalogName;
    },
    
    _getAdditionalCreationParameters: function()
    {
        return {
            forceMode: 'disabled',
            forceValues: {
                catalog: this._contentCatalog,
            },
            rootContentPath: this._rootContentPath,
            additionalWorkflowParameters: {
                'org.ametys.odf.workflow.AbstractCreateODFContentFunction$catalog': this._contentCatalog
            }
        };
    },
    
    _getAdditionalLoadValues: function()
    {
        // Only load the micro skills for the macro-skill by setting the value of parentMacroSkill field
        var values = {};
        values['reference-parentMacroSkill-eq'] = this._parentMacroSkill;
        
        return values;
    },
    
    _openCreatedContent: function(contentId)
    {
        // Nothing
    }
})