/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that will be responsible for the edit the catalog of the content
 * The button will be enabled only if the content is modifiable, not locked, with shared children and user has sufficient rights.
 * @private
 */
Ext.define('Ametys.plugins.odf.content.controller.DeleteODFContentController', {
    extend: 'Ametys.plugins.cms.content.controller.SmartContentController',
    
    _updateTooltipDescription: function (description, params)
    {
        description = this._handlingMultiple (description, 'allright', params['allright-contents']);
        description = this._handlingMultiple(description, 'noread', params['noread-contents']);
        description = this._handlingMultiple(description, "locked", params['locked-contents']);
        description = this._handlingMultiple(description, "noright", params['noright-contents']);
        description = this._handlingMultiple(description, "referenced", params['referenced-contents']);
        description = this._handlingMultiple(description, "nomodifiable", params['unmodifiable-contents']);
        description = this._handlingMultiple(description, "workflowaction", params['invalidworkflowaction-contents']);
        description = this._handlingMultiple(description, "workflowstep", params['invalidworkflowstep-contents']);
        
        this.setDescription (description);
    },

    _getStatus: function (targets)
    {
      this.disable();
      
      var contentIds = [];
      for (var i=0; i < targets.length; i++)
      {
          contentIds.push(targets[i].getParameters().id);
      }
      
      this.serverCall ('getStatus', [contentIds], this._getStatusCb, {arguments: targets, cancelCode: this.self.getName() + "$" + this.getId(), refreshing: true });
    }
});