/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool is a tool that display a tree of orgunits.
 */
Ext.define('Ametys.plugins.odf.orgunit.OrgUnitTreeTool', {
	extend: "Ametys.plugins.odf.tree.AbstractODFTreeTool",
    
    /**
     * @property {String[]} _openableTypes The list of content types to open on double-click
     * @private
     */
    _openableTypes: ['org.ametys.plugins.odf.Content.orgunit'],
    
    getOpenableContentTypes: function()
    {
        return this._openableTypes;
    },
    
    _getTreeConfig: function()
    {
        var treeCfg = this.callParent(arguments);
        return Ext.apply(treeCfg, {
            activeIndicators: ["odf-indicator-code"],
            enableIndicatorMenu: false
        });
    },
    
    _getPathInTree: function(contentId, rootId, callback, scope, args)
    {
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.ODFHelper",
            methodName: "getOrgUnitPath",
            parameters: [contentId],
            callback: {
                handler: callback,
                scope: scope || this,
                arguments: args
            },
            waitMessage: false
        });
    },
   	
    _setContentRootNode: function(contentId, pathToSelect)
    {
        // The root orgunit should always be the root node
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.orgunit.RootOrgUnitProvider",
            methodName: "getRootId",
            parameters: [],
            callback: {
                handler: this._getOrgUnitRootCb,
                scope: this,
                arguments: [contentId]
            },
            waitMessage: false
        });
    },
    
    /**
     * @private
     * Callback after retrieving the root id. Set the root node.
     * @param {String} rootId The id of root orgunits
     * @param {Object} args callback arguments
     */
    _getOrgUnitRootCb: function(rootId, args)
    {
        var contentId = args[0];
        
        if (contentId != null)
        {
            // Get path to current selected orgunit
            this._getPathInTree(contentId, rootId, this._getPathToSelect, this, [rootId]);
        }
        else
        {
            this._treePanel.setContentRootNode(
	            rootId, 
	            {
	                allowDrag: false,
	                allowDrop: true
	            },
	            Ext.bind(this._refreshed, this, [])
	        );  
        }
    },
    
    /**
     * @private
     * Callback after retrieving the path of the current selected orgunit
     * @param {String} pathToSelect The path of the orgunit
     * @param {Object} args callback arguments
     */
    _getPathToSelect: function(pathToSelect, args)
    {
        this._treePanel.setContentRootNode(
                args[0], 
                {
                    allowDrag: false,
                    allowDrop: true
                },
                Ext.bind(function() { this._treePanel.setSelection(this._treePanel.getRootNode()); this._refreshed(); }, this, [])
            );  
    },
    
    _onSelectionChanged: function(message)
    {
        message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
        
        var contentTargets = message.getTargets(Ametys.message.MessageTarget.CONTENT);
        if (contentTargets.length > 0)
        {
            var contentId = contentTargets[0].getParameters().id;
            if (contentId == this._treePanel.getRootNode().get('contentId'))
            {
                // Initialize the current selection targets
                this._currentSelectionTargets = contentTargets;
            }
        }
        
        this.callParent(arguments);
    }
});