/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class overrides the default SearchGridHelper to handle default renderer for 'educational-path' type
 */
Ext.define("Ametys.plugins.odf.search.SearchGridHelper", {
    override: "Ametys.plugins.cms.search.SearchGridHelper",
   
    _getDefaultRenderer: function(data, cfg)
    {
        var type = data.type.toLowerCase();
        switch (type) 
        {
            case 'educational-path':
                return 'Ametys.plugins.odf.search.ODFContentSearchTool.renderEducationalPath';
            default:
                return this.callParent(arguments);
        }
    },
    
    _getDefaultConvertor: function (id, data)
    {
        var type = data.type.toLowerCase();
        if (type == 'educational-path') 
        {
            return Ext.bind(Ametys.plugins.cms.search.SearchGridHelper.convertContent, Ametys.plugins.cms.search.SearchGridHelper, [id], true);
        }
        else
        {
            return this.callParent(arguments);
        }
    }
});