/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf;

import java.util.Map;

import org.ametys.cms.repository.Content;

/**
 * Interface to update ODF contents after a copy
 */
public interface CopyODFUpdater
{
    /**
     * Update contents after the full copy of an ODF content. Implements this method when you need to do some stuff when all contents have been copied.
     * @param initialCatalogName the name of initial catalog
     * @param newCatalogName the name of new catalog
     * @param copiedContents the initial contents with their copied content
     * @param targetParentContent the target parent content where the contents are copied. Can be null.
     */
    public void updateContents (String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent);
}
