/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import javax.jcr.Node;

import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;

/**
 * Catalog java object
 */
public class Catalog extends SimpleAmetysObject<CatalogFactory> implements ModifiableModelAwareDataAwareAmetysObject
{
    /**
     * Constructor
     * @param node The JCR node
     * @param parentPath The parent path
     * @param catalogFactory the object factory
     */
    public Catalog(Node node, String parentPath, CatalogFactory catalogFactory)
    {
        super(node, parentPath, catalogFactory);
    }

    /**
     * Get the title of catalog
     * @return the title
     */
    public String getTitle()
    {
        return getValue(CatalogModel.TITLE);
    }
    
    /**
     * Set the title of catalog
     * @param title the title to set
     */
    public void setTitle (String title)
    {
        setValue(CatalogModel.TITLE, title);
    }
    
    /**
     * Set the default state of this catalog
     * @param isDefault true to set this catalog as the default catalog
     */
    public void setDefault(boolean isDefault)
    {
        setValue(CatalogModel.IS_DEFAULT, isDefault);
    }
    
    /**
     * Determines if this catalog is the default catalog
     * @return true if the catalog is the default catalog
     */
    public boolean isDefault()
    {
        return getValue(CatalogModel.IS_DEFAULT, false, false);
    }

    public ModifiableIndexableDataHolder getDataHolder()
    {
        JCRRepositoryData repositoryData = new JCRRepositoryData(getNode());
        return new DefaultModifiableModelAwareDataHolder(repositoryData, _getFactory().getModel());
    }
}
