/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import java.util.Map;
import java.util.Map.Entry;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.ProgramTranslationUpdater;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Copy updater to update the publishable value of program items after a catalog copy
 */
public class PublishableCopyUpdater extends AbstractLogEnabled implements CopyCatalogUpdater, ProgramTranslationUpdater
{
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Entry<Content, Content> contentMapping : copiedContents.entrySet())
        {
            Content initialContent = contentMapping.getKey();
            if (initialContent instanceof ProgramItem initialProgramItem)
            {
                ProgramItem copiedProgramItem = (ProgramItem) contentMapping.getValue();
                copiedProgramItem.setPublishable(initialProgramItem.isPublishable());
                if (copiedProgramItem instanceof ModifiableContent modifiableContent && modifiableContent.needsSave())
                {
                    modifiableContent.saveChanges();
                }
            }
        }
    }
}
