/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

import org.ametys.cms.data.File;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.runtime.config.Config;

/**
 * Helper class containing useful methods to implements CDM-fr extension.
 */
public abstract class AbstractCDMfrExtension implements CDMfrExtension
{
    /**
     * Computes an external URL for retrieving files after export.
     * @param content the current exported content
     * @param file the file being exported
     * @param dataPath the data path of the file
     * @return an URL for retrieving the file
     */
    protected String _getFileAbsoluteUrl(Content content, File file, String dataPath)
    {
        StringBuilder uri = new StringBuilder();
        uri.append("/_odf")
           .append("/_contents")
           .append(FilenameUtils.encodePath(content.getPath()))
           .append("/_attribute/")
           .append(dataPath)
           .append("/").append(FilenameUtils.encodeName(file.getName()));
        
        StringBuilder resultPath = new StringBuilder();
        resultPath.append(HttpUtils.sanitize(Config.getInstance().getValue("cms.url")))
                  .append(URIUtils.encodePath(uri.toString()))
                  .append("?objectId=" + URIUtils.encodeParameter(content.getId()));
        
        return resultPath.toString();
    }
}
