/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.excalibur.source.Source;

import org.ametys.cms.repository.DefaultContent;
import org.ametys.odf.CallWSHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;

/**
 * Processor to delete the program on remote servers.
 */
public class DeleteRemoteProgramProcessor extends SendCDMfrProcessor
{
    /** The component role. */
    @SuppressWarnings("hiding")
    public static final String ROLE = DeleteRemoteProgramProcessor.class.getName();
    
    @Override
    protected Source _getCDMfrContent(Program program) throws IOException
    {
        // We don't need the CDM-fr content for this process
        return null;
    }
    
    @Override
    protected void processProgram(Program program, InputStream cdmfrContent) throws IOException
    {
        Map<String, String> params = new HashMap<>();
        params.put(ProgramItem.CODE, program.getCode());
        params.put(ProgramItem.CATALOG, program.getCatalog());
        params.put(DefaultContent.METADATA_LANGUAGE, program.getLanguage());
        
        // Delete program on remote application
        CallWSHelper.callWS("_odf-sync/delete-program", params, new SLF4JLoggerAdapter(getLogger()));
    }
}
