/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.clientsideelement;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.tuple.Pair;

import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.odf.skill.workflow.SkillEditionFunction;

/**
 * This element creates an action button to delete a ODF content
 */
public class DeleteSkillClientSideElement extends org.ametys.cms.clientsideelement.DeleteContentClientSideElement
{
    /** The content types helper */
    protected ContentTypesHelper _contentTypesHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _contentTypesHelper = (ContentTypesHelper) manager.lookup(ContentTypesHelper.ROLE);
    }

    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        if (!ODFSkillsHelper.isSkillsEnabled())
        {
            return List.of();
        }
        
        return super.getScripts(ignoreRights, contextParameters);
    }
    
    @Override
    protected boolean _isContentReferenced(Content content)
    {
        if (_contentTypesHelper.isInstanceOf(content, SkillEditionFunction.MACRO_SKILL_TYPE))
        {
            for (Pair<String, Content> refPair : _contentHelper.getReferencingContents(content))
            {
                // The ref content is not ignored
                if (!"parentMacroSkill".equals(refPair.getKey()))
                {
                    return true;
                }
            }
            
            return false;
        }
        
        return content.hasReferencingContents();
    }
}
