/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.course;

import java.util.List;


/**
 * Interface representing a container of courses
 */
public interface CourseContainer
{
    /**
     * Get the list of child {@link Course}
     * @return the courses id in a List
     */
    public List<Course> getCourses();
    
    /**
     * Determines if the container contains a courses
     * @param courseId id of the {@link Course} to test
     * @return true if the course exists
     */
    public boolean containsCourse (String courseId);
    
    /**
     * Determines if the container contains courses
     * @return true if the container contains at least one course
     */
    public boolean hasCourses();
}
