/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.export.pdf;

import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.SchedulerException;

import org.ametys.cms.clientsideelement.SmartContentClientSideElement;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.runtime.authentication.AccessDeniedException;

/**
 * Client side element to schedule a generation of educational booklet
 */
public class ScheduleEducationalBookletClientSideElement extends SmartContentClientSideElement
{
    /** The Ametys scheduler */
    protected Scheduler _scheduler;
    private String _schedulableId;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _scheduler = (Scheduler) smanager.lookup(Scheduler.ROLE);
    }
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        _schedulableId = configuration.getChild("class").getChild("schedulable").getValue();
    }
    
    /**
     * Adds a new task.
     * @param label The label
     * @param description The description
     * @param fireProcess the fire process
     * @param cron The cron expression
     * @param schedulableId The id of the schedulable model
     * @param params The values of the parameters
     * @return A result map
     * @throws SchedulerException if an error occured
     */
    @Callable(rights = Callable.CHECKED_BY_IMPLEMENTATION)
    public Map<String, Object> add(String label, String description, String fireProcess, String cron, String schedulableId, Map<String, Object> params) throws SchedulerException
    {
        if (hasRight(getRights(null)) && schedulableId.equals(_schedulableId))
        {
            return _scheduler.add(label, description, fireProcess, cron, schedulableId, params);
        }
        throw new AccessDeniedException(_currentUserProvider.getUser() + "' tried to execute schedulable '" + schedulableId + "' without any of the following rights: " + getRights(null));
    }
}
