/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.init;

import java.util.Map;

import org.apache.avalon.framework.component.Component;

import org.ametys.runtime.plugin.component.Prioritizable;

/**
 * ODF reference table data description to import on initialization.
 */
public interface OdfRefTableData extends Component, Prioritizable
{
    /**
     * Data to import for the given path (by default plugin://ref-data/*.csv) by content type id.
     * @return Path of CSV files to import by content type id.
     */
    public Map<String, String> getDataToImport();
}
