/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.migration;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

/**
 * Initialization class to migrate totalDurationOf* attribute from ODF 4.0 to ODF 4.1 or 4.3.
 */
public class MigrateCoursePart implements org.ametys.runtime.plugin.Init, Serviceable
{
    /** The Migrate course part component */
    protected MigrateCoursePartComponent _migrateCoursePartComponent;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _migrateCoursePartComponent = (MigrateCoursePartComponent) manager.lookup(MigrateCoursePartComponent.ROLE);
    }

    @Override
    public void init() throws Exception
    {
        _migrateCoursePartComponent.migrateCourseParts();
    }
}
