/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.oai;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.runtime.config.Config;

/**
 * Generator for the "Identify" OAI request.
 */
public class IdentifyGenerator extends AbstractOAIVerbGenerator implements Serviceable
{
    private RootOrgUnitProvider _rootOrgUnitProvider;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _rootOrgUnitProvider = (RootOrgUnitProvider) serviceManager.lookup(RootOrgUnitProvider.ROLE);
    }
    
    @Override
    protected void generateVerb() throws IOException, SAXException, ProcessingException
    {
        XMLUtils.startElement(contentHandler, "Identify");
        
        OrgUnit rootOrgUnit = _rootOrgUnitProvider.getRoot();
        XMLUtils.createElement(contentHandler, "repositoryName", "Catalogue des formations \"" + rootOrgUnit.getTitle() + "\" (" + rootOrgUnit.getUAICode() + ")");
        XMLUtils.createElement(contentHandler, "baseURL", getURL());
        XMLUtils.createElement(contentHandler, "protocolVersion", "2.0");
        XMLUtils.createElement(contentHandler, "adminEmail", (String) Config.getInstance().getValue("smtp.mail.sysadminto"));
        XMLUtils.createElement(contentHandler, "earliestDatestamp", "1970-01-01T00:00:00Z");
        XMLUtils.createElement(contentHandler, "deletedRecord", "no");
        XMLUtils.createElement(contentHandler, "granularity", "YYYY-MM-DDThh:mm:ssZ");
        
        XMLUtils.endElement(contentHandler, "Identify");
    }
    
    @Override
    protected Collection<String> getAllowedParameters()
    {
        return Arrays.asList("verb");
    }
    
    @Override
    protected Collection<String> getRequiredParameters()
    {
        return Arrays.asList("verb");
    }
}
