/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.oai;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

/**
 * Generator for the <code>ListMetadataFormat</code> verb.<br>
 * Returns oai_dc and cdm formats.
 */
public class ListMetadataFormatsGenerator extends AbstractOAIVerbGenerator
{
    @Override
    protected Collection<String> getRequiredParameters()
    {
        return Arrays.asList("verb");
    }

    @Override
    protected Collection<String> getAllowedParameters()
    {
        return Arrays.asList("verb", "identifier");
    }

    @Override
    protected void generateVerb() throws IOException, SAXException, ProcessingException
    {
        XMLUtils.startElement(contentHandler, "ListMetadataFormats");

        XMLUtils.startElement(contentHandler, "metadataFormat");
        XMLUtils.createElement(contentHandler, "metadataPrefix", "oai_dc");
        XMLUtils.createElement(contentHandler, "schema", "http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
        XMLUtils.createElement(contentHandler, "metadataNamespace", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        XMLUtils.endElement(contentHandler, "metadataFormat");
        
        XMLUtils.startElement(contentHandler, "metadataFormat");
        XMLUtils.createElement(contentHandler, "metadataPrefix", "cdm");
        XMLUtils.createElement(contentHandler, "schema", "http://cdm-fr.fr/2011/schemas/CDMFR.xsd");
        XMLUtils.createElement(contentHandler, "metadataNamespace", "http://cdm-fr.fr/2011/CDM");
        XMLUtils.endElement(contentHandler, "metadataFormat");
        
        XMLUtils.endElement(contentHandler, "ListMetadataFormats");
    }
}
