/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import java.util.List;

/**
 * Represents a part of a {@link Program}, traversable, be it the Program itself, a {@link SubProgram} or a {@link Container}.
 */
public interface TraversableProgramPart extends ProgramPart
{
    /** Name of the attribute holding the direct children */
    public static final String CHILD_PROGRAM_PARTS = "childProgramParts";
    
    /**
     * Returns the child {@link ProgramPart}s
     * @return the child {@link ProgramPart}s in a List
     */
    public List<ProgramPart> getProgramPartChildren();
    
    /**
     * Determines if this {@link ProgramPart} contains child program parts
     * @return true if this {@link ProgramPart} contains at least a child program part
     */
    public boolean hasProgramPartChildren();
    
    /**
     * Determines if this {@link ProgramPart} contains the given program part as child
     * @param contentId id of the {@link ProgramPart} to test
     * @return true if the content is part of this {@link ProgramPart}
     */
    public boolean containsProgramPart(String contentId);
}
