/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.properties.section.content;

import org.ametys.cms.properties.section.content.ContentViewSection;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.repository.AmetysObject;

/**
 * Section to display managers view of the content if it is a program item or an orgunit.
 */
public class ODFItemManagersSection extends ContentViewSection
{
    @Override
    public boolean supports(AmetysObject ametysObject)
    {
        return ametysObject instanceof ProgramItem || ametysObject instanceof OrgUnit;
    }
}
