/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rncp;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.reading.ServiceableReader;
import org.xml.sax.SAXException;

/**
 * Abstract reader for RNCP  abstract program sheet.
 */
public abstract class AbstractRNCPAbstractProgramReader extends ServiceableReader
{
    private RNCPModelHelper _rncpModelHelper;
    
    @Override
    public String getMimeType()
    {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _rncpModelHelper = (RNCPModelHelper) smanager.lookup(RNCPModelHelper.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String programId = getProgramId(request);
        String subProgramId = getSubProgramId(request);
        String modelId = request.getParameter("model");
        _rncpModelHelper.updateAbstractProgramRNCPSheet(modelId, programId, subProgramId, out);
    }
    
    /**
     * Get the subProgram ID.
     * @param request The request
     * @return The subprogram ID
     */
    protected abstract String getSubProgramId(Request request);

    /**
     * Get the program ID.
     * @param request The request
     * @return The program ID
     */
    protected abstract String getProgramId(Request request);
}
