/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.ametys.odf.program.SubProgramFactory;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * OSWorkflow function for creating a odfContent.
 */
public class CreateSubProgramFunction extends AbstractCreateODFProgramItemFunction
{
    /** Content name prefix for programs */
    public static final String CONTENT_NAME_PREFIX = "subprogram-";
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return SubProgramFactory.SUBPROGRAM_NODETYPE;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_SUB_PROGRAM_FUNCTION_LABEL");
    }
}
