/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.Map;
import java.util.Set;

import org.ametys.cms.repository.Content;
import org.ametys.odf.program.ContainerFactory;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.odf.workflow.CreateContainerFunction;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * OSWorkflow function to create a container by copy of another
 */
public class CreateContainerByCopyFunction extends AbstractCreateProgramItemByCopyFunction
{
    @Override
    protected String _getContentNamePrefix()
    {
        return CreateContainerFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return ContainerFactory.CONTAINER_NODETYPE;
    }

    @Override
    protected Set<String> _getChildrenReferencesName()
    {
        return Set.of(TraversableProgramPart.CHILD_PROGRAM_PARTS);
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        return parent instanceof ProgramPart;
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        return ProgramPart.PARENT_PROGRAM_PARTS;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_CONTAINER_BY_COPY_FUNCTION_LABEL");
    }
}
