/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.course;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.ModifiableContentFactory;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.TraversableAmetysObjectHelper;

/**
 * {@link CourseFactory} for handling {@link Course}
 */
public class CourseFactory extends ModifiableContentFactory
{
    /** {@link Course} nodetype for resources collection */
    public static final String COURSE_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":courseContent";

    /** {@link Course} content type */
    public static final String COURSE_CONTENT_TYPE = "org.ametys.plugins.odf.Content.course";

    private RootOrgUnitProvider _rootOrgUnitProvider;

    private ODFHelper _odfHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) manager.lookup(RootOrgUnitProvider.ROLE);
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
    }
    
    @Override
    public Course getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new Course(node, parentPath, this);
    }

    /**
     * Creates a child to the given object.
     * 
     * @param object the parent {@link AmetysObject}.
     * @param name the new object's name.
     * @param type the new object's type.
     * @return the newly created {@link AmetysObject}.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public CourseList createChild(JCRTraversableAmetysObject object, String name, String type) throws AmetysRepositoryException
    {
        return TraversableAmetysObjectHelper.createChild(object, this, name, type, _ametysFactoryExtensionPoint, _resolver, getLogger());
    }
    
    CourseList getChild(String path, Course object) throws AmetysRepositoryException, UnknownAmetysObjectException
    {
        return TraversableAmetysObjectHelper.getChild((JCRTraversableAmetysObject) object, this, path, _resolver, getLogger());
    }

    boolean hasChild(String name, Course object) throws AmetysRepositoryException
    {
        return TraversableAmetysObjectHelper.hasChild(object, name, this._ametysFactoryExtensionPoint, getLogger());
    }

    AmetysObjectIterable<AmetysObject> getChildren(Course object) throws AmetysRepositoryException
    {
        return TraversableAmetysObjectHelper.getChildren((JCRTraversableAmetysObject) object, this, _resolver, getLogger());
    }
    
    String _getRootOrgUnitRNE()
    {
        return _rootOrgUnitProvider.getRoot().getUAICode();
    }
    
    ODFHelper _getODFHelper()
    {
        return _odfHelper;
    }
}
