/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rights;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Access controller based on managers attribute
 *
 */
public class ODFManagerAccessController extends AbstractODFRoleAccessController
{
    @Override
    protected String _getTargetProfileId()
    {
        return  _odfRightHelper.getManagerProfileId();
    }
    
    @Override
    protected Set<UserIdentity> _getLocalAllowedUsers(Content content)
    {
        UserIdentity[] allowedUsers = _odfRightHelper.getManagers(content);
        return allowedUsers != null ? Arrays.stream(allowedUsers).collect(Collectors.toSet()) : new HashSet<>();
    }
    
    @Override
    protected String _getRoleAttributePath()
    {
        return ODFRightHelper.MANAGERS_FIELD_PATH;
    }
    
    @Override
    protected I18nizableText _getRoleLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_MANAGER_ACCESS_CONTROLLER_ROLE");
    }

}
