<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:param name="start">0</xsl:param>
    <xsl:param name="limit">0</xsl:param>
    
    <xsl:template match="programs">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            
            <xsl:choose>
                <xsl:when test="$limit != '' and $start != '' and $limit &gt; 0">
                    <xsl:variable name="last" select="$start + $limit"/>
                    <xsl:apply-templates select="program[position() &gt; $start and position() &lt;= $last]"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="*"/>
                </xsl:otherwise>
            </xsl:choose>
            
            <total><xsl:value-of select="count(program)"/></total>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>
