<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			    xmlns:docbook="http://docbook.org/ns/docbook"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
			    xmlns:cms="http://ametys.org/cms/3.0"
				xmlns:date="http://exslt.org/dates-and-times"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
			    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
				xmlns:stringutils="org.apache.commons.lang.StringUtils"
			    exclude-result-prefixes="docbook"
			    extension-element-prefixes="cms date resolver stringutils">

    <xsl:import href="plugin:cms://stylesheets/helper/common.xsl"/>
    <xsl:import href="view:cms://stylesheets/io/docbook2fo.xsl" />
	<xsl:import href="plugin:odf://stylesheets/content/common2pdf.xsl"/>
		
	<xsl:param name="contextPath" />
	
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="page"
                    page-width="210mm" page-height="297mm" margin-left="0cm"
                    margin-right="0cm" margin-top="2cm" margin-bottom="2cm">
                    <fo:region-body margin-top="0cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before extent="1cm">
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after extent="0.5cm">
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <xsl:apply-templates select="/view/content" />
        </fo:root>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
    </xsl:template>
    
	<!--+
		+  PAGE CONTENT
		+ -->	
	<xsl:template match="content">
		<fo:page-sequence master-reference="page">
            
            <xsl:call-template name="xsl-region-before"/>
            
            <xsl:call-template name="xsl-region-after"/>
            
	        <!-- Body region -->	
 			<fo:flow flow-name="xsl-region-body">
                <fo:block margin-left="1cm" margin-right="1cm">
                    <xsl:call-template name="main-body-block"/>
                    
                    <fo:block margin-left="0cm" margin-right="0cm">
    					<xsl:call-template name="header"/>
    					<xsl:call-template name="body"/>
    					<xsl:call-template name="subprogram-content"/>
                    </fo:block>
				</fo:block>
				<fo:block id="theEnd" />
			</fo:flow>
			
		</fo:page-sequence>	
	</xsl:template>
    
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block margin-left="1cm" margin-right="1cm">
                <xsl:call-template name="main-region-after-block"/>
                
                <fo:table table-layout="fixed" margin-top="0pt" padding-top="0pt">
                <fo:table-column column-width="4.5cm"/>
                <fo:table-column column-width="10cm"/>
                <fo:table-column column-width="4.5cm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block text-align="left">
                                <xsl:variable name="now" select="date:date-time()"/>
                                <xsl:number format="01" value="date:day-in-month($now)"/>
                                <xsl:text>/</xsl:text>
                                <xsl:number format="01" value="date:month-in-year($now)"/>
                                <xsl:text>/</xsl:text>
                                <xsl:value-of select="date:year($now)"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="center" font-size="5px">
                                <i18n:text i18n:key="PLUGINS_ODF_PDF_CATALOG_FOOTER_TEXT" i18n:catalogue="plugin.odf"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right"><i18n:text i18n:key="PLUGINS_ODF_PDF_CATALOG_FOOTER_PAGE_NUMBER" i18n:catalogue="plugin.odf"/> <fo:page-number /> / <fo:page-number-citation ref-id="theEnd" /></fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
	
	<xsl:template name="title">
        <fo:block>
        	<xsl:call-template name="title-style">
            	<xsl:with-param name="level" select="'2'"/>
            </xsl:call-template>
            <xsl:variable name="title"><xsl:value-of select="metadata/title"/></xsl:variable>
            <xsl:value-of select="stringutils:upperCase($title)"/>
        </fo:block>
	</xsl:template>
    
    <xsl:template name="header-top">
    </xsl:template>
    
    <xsl:template name="header-bottom">
    </xsl:template>

	<xsl:template name="header">
		<xsl:call-template name="header-top"/>
        
        <xsl:call-template name="title"/>
        
        <fo:block xsl:use-attribute-sets="brief">
        	
            <fo:block xsl:use-attribute-sets="brief-title"><i18n:text i18n:key="CONTENT_PROGRAM_BRIEF_TITLE" i18n:catalogue="plugin.odf"/></fo:block>
            
            <!-- Degree -->
            <xsl:if test="metadata/degree ">
            	<fo:block>
	        		<fo:inline font-weight="bold"><i18n:text i18n:key="CONTENT_PROGRAM_DEGREE" i18n:catalogue="plugin.odf"/><xsl:text> : </xsl:text></fo:inline>
	        		<fo:inline><xsl:value-of select="metadata/degree/@title"/></fo:inline>
	        	</fo:block>
        	</xsl:if>
        		
            <!-- Domain -->
            <xsl:if test="metadata/domain">
                <fo:block>
                    <fo:inline font-weight="bold"><i18n:text i18n:key="PLUGINS_ODF_PROGRAM_DOMAIN" i18n:catalogue="plugin.odf"/><xsl:text> : </xsl:text></fo:inline>
                    <fo:inline><xsl:for-each select="metadata/domain">
        				<xsl:value-of select="@title"/><xsl:if test="position() != last()">,</xsl:if>
        			</xsl:for-each></fo:inline>
                </fo:block>
            </xsl:if>
            
            <!-- Mention -->
       		<xsl:if test="metadata/mention">
       			<fo:block>
       				<fo:inline font-weight="bold"><i18n:text i18n:key="CONTENT_PROGRAM_MENTION" i18n:catalogue="plugin.odf"/><xsl:text> : </xsl:text></fo:inline>
       				<fo:inline><xsl:value-of select="metadata/mention/@title"/></fo:inline>
       			</fo:block>
       		</xsl:if>
        		
        	<!-- Speciality -->
       		<xsl:if test="normalize-space(metadata/speciality ) != ''">
       			<fo:block>
       				<fo:inline font-weight="bold"><i18n:text i18n:key="CONTENT_PROGRAM_SPECIALITY" i18n:catalogue="plugin.odf"/><xsl:text> : </xsl:text></fo:inline>
       				<fo:inline><xsl:value-of select="metadata/speciality"/></fo:inline>
       			</fo:block>
       		</xsl:if>
        </fo:block>
        
		<xsl:call-template name="header-bottom"/>
	</xsl:template>
	
	<xsl:template name="body-top">
	</xsl:template>
	
	<xsl:template name="body-bottom">
	</xsl:template>
	
    <xsl:template name="body">
        <xsl:call-template name="body-top"/>
        
        <fo:block space-before="0.5cm">
            <fo:block>
                <fo:table table-layout="fixed">
                    <fo:table-column column-width="13cm"/>
                    <fo:table-column column-width="6cm"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell margin-left="0cm" margin-right="0cm">
                                <fo:block>
                                	<xsl:call-template name="body-content">
                                		<xsl:with-param name="truelevel" select="2"/>
                                	</xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell margin-left="0cm" margin-right="0cm" padding-left="3pt">
                                <fo:block>
                                	<xsl:call-template name="right-content">
                                		<xsl:with-param name="truelevel" select="2"/>
                                	</xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block>
        
        <xsl:call-template name="body-bottom"/>
    </xsl:template>
    
    <xsl:template name="body-content">
    	<xsl:param name="truelevel"/>
    	
    	<!-- TAB 01: PRESENTATION -->
    	<xsl:call-template name="presentation">
    		<xsl:with-param name="truelevel" select="$truelevel"/>
    	</xsl:call-template>
    	
    	<!-- TAB 02: ORGANISATION -->
    	<xsl:call-template name="organization">
    		<xsl:with-param name="truelevel" select="$truelevel"/>
    	</xsl:call-template>
    	
    	<!-- TAB 03: ADMISSION  -->
    	<xsl:call-template name="admission">
    		<xsl:with-param name="truelevel" select="$truelevel"/>
    	</xsl:call-template>
    	
    	<!-- TAB 04: ET APRES  -->
    	<xsl:call-template name="further">
    		<xsl:with-param name="truelevel" select="$truelevel"/>
    	</xsl:call-template>
    	
    	<!-- Tab 05 : Contacts -->
        <xsl:call-template name="contacts">
            <xsl:with-param name="truelevel" select="$truelevel"/>            
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | TAB 01: Presentation 
         +-->
    <xsl:template name="presentation">
    	<xsl:param name="truelevel"/>
    	
    	<!-- Présentation -->
    	<xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/presentation"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_PRESENTATION'"/>
        </xsl:call-template>
        
        <!-- Objectifs -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/objectives"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_OBJECTIVES'"/>
        </xsl:call-template>
        
		<!-- Compétences --> 
		<xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/qualification"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_SKILLS'"/>
        </xsl:call-template>
        
        <!-- Formation internationale et Dimension internationale -->
         <xsl:if test="metadata/internationalEducation[@title] or metadata/internationalDimension">
	          <xsl:if test="metadata/internationalEducation[@title]">
	         		<fo:block>
			            <xsl:call-template name="title-style">
			            	<xsl:with-param name="level" select="$truelevel + 1"/>
			            </xsl:call-template>
			            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNATIONAL_DIMENSION"/>
			        </fo:block>
		           <xsl:for-each select="metadata/internationalEducation">
		           		<xsl:if test="position() > 1"><xsl:text>, </xsl:text></xsl:if>
		           		<xsl:value-of select="@title"/>
		           </xsl:for-each>
	          </xsl:if>

	          <xsl:call-template name="common-content-richtext2pdf-field">
	              <xsl:with-param name="value" select="metadata/internationalDimension"/>
	              <xsl:with-param name="level" select="$truelevel + 2 "/>
	          </xsl:call-template>
         </xsl:if>	 
        
        <!-- Informations supplémentaires -->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/additionalInformations"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_ADDITIONAL_INFORMATIONS'"/>
         </xsl:call-template> 
         
         <!-- Témoignage(s) -->
         <xsl:if test="metadata/testimonies/entry/text">
                <fo:block>
		            <xsl:call-template name="title-style">
		            	<xsl:with-param name="level" select="$truelevel + 1"/>
		            </xsl:call-template>
		            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TESTIMONIES"/>
		        </fo:block>
                <xsl:for-each select="metadata/testimonies/entry">
                	<!-- <xsl:if test="image">	
						<div class="content-illustration small">
		                	<img src="{resolver:resolveBoundedImage(image/@type, image/@path, '100', '100')}" alt=""/>
		            	</div>	       			
					</xsl:if> -->
                	<xsl:if test="normalize-space(title ) != ''">
	    	       	 	<fo:block>
				            <xsl:call-template name="title-style">
				            	<xsl:with-param name="level" select="$truelevel + 2"/>
				            </xsl:call-template>
				            <xsl:value-of select="title"/>
				        </fo:block>
    	       	 	</xsl:if>
    	       	 	<xsl:call-template name="common-content-richtext2pdf-field">
		                 <xsl:with-param name="value" select="text"/>
		                 <xsl:with-param name="level" select="$truelevel + 2"/>
		             </xsl:call-template> 
				</xsl:for-each>
          </xsl:if>        
    </xsl:template>
    
    <!-- +
         | TAB 02: Organisation 
         +-->
    <xsl:template name="organization">
    	<xsl:param name="truelevel"/>
        
        <!-- Contenu de la formation -->                        
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/teachingOrganization"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_TEACHING_ORGANIZATION'"/>
        </xsl:call-template>
            
        <xsl:if test="subprogram|container|courseList">
            <!-- Organisation de la formation -->
            <fo:block>
	            <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PROGRAM_TITLE"/>
	        </fo:block>
		</xsl:if>
			
		<xsl:if test="subprogram">
			<fo:block>
				<xsl:call-template name="para-style"/>
	            <fo:list-block>
	            	<xsl:call-template name="ol-style"/>
	                <xsl:apply-templates select="subprogram"/>
	            </fo:list-block>
	        </fo:block>
        </xsl:if>
        
        <xsl:if test="container">
        	<fo:block>
				<xsl:call-template name="para-style"/>
	            <fo:list-block start-indent="10pt">
	            	<xsl:call-template name="ol-style"/>
	                <xsl:apply-templates select="container"/>
	            </fo:list-block>
	       	</fo:block>
        </xsl:if>
        
        <xsl:if test="courseList">
        	<fo:block>
				<xsl:call-template name="para-style"/>
	            <fo:list-block>
	            	<xsl:call-template name="ol-style"/>
	                <xsl:apply-templates select="courseList"/>
	            </fo:list-block>
	        </fo:block>
        </xsl:if>
        
        <!-- Contrôle des connaissances -->                        
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/knowledgeCheck"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_KNOWLEDGE_CHECK'"/>
        </xsl:call-template>            
        
        <!-- Aménagements particuliers -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/universalAdjustment"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_UNIVERSAL_ADJUSTMENT'"/>
        </xsl:call-template>
        
          <!-- Alternance -->
		  <xsl:if test="metadata/apprenticeshipOpen = 'true'">
    	        <fo:block>
		            <xsl:call-template name="title-style">
		            	<xsl:with-param name="level" select="$truelevel + 1"/>
		            </xsl:call-template>
		            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_OPEN"/>
		        </fo:block>
    	        <xsl:if test="normalize-space(metadata/apprenticeshipContract/@title ) != ''">
   	        		<fo:block font-weight="bold"><i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_CONTRACT_KIND" i18n:catalogue="plugin.odf"/> : </fo:block>
		            <fo:block>
		            <xsl:for-each select="metadata/apprenticeshipContract">
		            	<xsl:if test="position() > 1"><xsl:text>, </xsl:text></xsl:if>
		            	<xsl:value-of select="@title"/>
		            </xsl:for-each>
   	        		</fo:block>
		        </xsl:if>
    	       	<xsl:call-template name="common-content-richtext2pdf-field">
	                <xsl:with-param name="value" select="metadata/apprenticeshipPeriod"/>
	                <xsl:with-param name="level" select="$truelevel + 1"/>
		        </xsl:call-template>
                <xsl:call-template name="common-content-richtext2pdf-field">
                    <xsl:with-param name="value" select="metadata/apprenticeshipModalities"/>
                    <xsl:with-param name="level" select="$truelevel + 1"/>
                </xsl:call-template>
			</xsl:if>
			
			<!-- Stages -->
			<xsl:if test="metadata/internshipOpen = 'true'">
				<xsl:element name="h{$truelevel + 1}">
            		<i18n:text i18n:key="CONTENT_PROGRAM_TRAINING_STRATEGY" i18n:catalogue="plugin.odf"/>
    	        </xsl:element>
				
				<xsl:if test="metadata/internship">
					<fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP"/></fo:block>
					<fo:block>
							<xsl:value-of select="metadata/internship/@title"/>
							<xsl:if test="normalize-space(metadata/internshipDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipDuration"/><xsl:text>)</xsl:text></xsl:if>
					</fo:block>
				</xsl:if>
				<xsl:if test="metadata/internshipAbroad">
					<fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP_ABROAD"/></fo:block>
	   				<fo:block>
	   						<xsl:value-of select="metadata/internshipAbroad/@title"/>
	   						<xsl:if test="normalize-space(metadata/internshipAbroadDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipAbroadDuration"/><xsl:text>)</xsl:text></xsl:if>
					</fo:block>
				</xsl:if>
				
				<!-- stages -->
	            <xsl:call-template name="common-content-richtext2pdf-field">
	                <xsl:with-param name="value" select="metadata/trainingStrategy"/>
	                <xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template> 
				
				<xsl:if test="metadata/internshipDescription/entry">
    	        <xsl:for-each select="metadata/internshipDescription/entry">
    	        	<fo:block font-weight="bold"><xsl:value-of select="title"/></fo:block>
    	        	<fo:list-block>
			        	<xsl:call-template name="ul-style">
		        			<xsl:with-param name="mark" select="@mark"/>
		        		</xsl:call-template>
		        		<xsl:if test="duration">
			        		<fo:list-item>
					            <fo:list-item-label><fo:block>* </fo:block></fo:list-item-label>
					            <fo:list-item-body start-indent="body-start()-5mm">
					                <fo:block>
					                <i18n:text i18n:key="PLUGINS_ODF_PROGRAM_INTERNSHIPS_DESCRIPTION_DURATION" i18n:catalogue="plugin.odf"/><xsl:text>: </xsl:text>
	    	        				<xsl:value-of select="duration"/><xsl:text> </xsl:text>
	    	        				</fo:block>
					            </fo:list-item-body>
					        </fo:list-item>
				        </xsl:if>
    	        		<xsl:if test="period">
    	        			<fo:list-item>
					            <fo:list-item-label><fo:block>* </fo:block></fo:list-item-label>
					            <fo:list-item-body start-indent="body-start()-5mm">
					                <fo:block>
    	        						<i18n:text i18n:key="PLUGINS_ODF_PROGRAM_INTERNSHIPS_DESCRIPTION_PERIOD" i18n:catalogue="plugin.odf"/><xsl:text>: </xsl:text>
    	        						<xsl:value-of select="period"/>
    	        					</fo:block>
					            </fo:list-item-body>
					        </fo:list-item>
    	        		</xsl:if>
    	        		<xsl:if test="kind">
   	        				<fo:list-item>
					            <fo:list-item-label><fo:block>* </fo:block></fo:list-item-label>
					            <fo:list-item-body start-indent="body-start()-5mm">
					                <fo:block>
										<xsl:call-template name="common-content-richtext2pdf-field">
							                <xsl:with-param name="value" select="kind"/>
							                <xsl:with-param name="level" select="$truelevel + 1"/>
							            </xsl:call-template> 
				            		</fo:block>
					            </fo:list-item-body>
					        </fo:list-item>
    	        		</xsl:if>

			        </fo:list-block>
    	        </xsl:for-each>
    	        </xsl:if>            
             </xsl:if> 
        
   	</xsl:template>
   	
    <!-- +
         | TAB 03: Admission 
         +-->
    <xsl:template name="admission">
    	<xsl:param name="truelevel"/>
        
        <!--  Condition d'accès -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/accessCondition"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_ACCESS_CONDITION'"/>
        </xsl:call-template>
        
        <!-- inscription -->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/inscription"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_INSCRIPTION'"/>
         </xsl:call-template>   

        <!-- Public cible -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/targetGroup"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_AUDIENCE_TARGET'"/>
        </xsl:call-template>
        
        <!-- Droits de scolarité -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/expenses"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_EXPENSES'"/>
        </xsl:call-template>       

         <!-- Pré requis nécessaires -->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/neededPrerequisite"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_NEEDED_PREREQUISITE'"/>
         </xsl:call-template>            
         
         <!-- Pré requis recommandés -->                        
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/recommendedPrerequisite"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_RECOMMENDED_PREREQUISITE'"/>
         </xsl:call-template>   
    </xsl:template>
    
    <!-- +
         | TAB 04: Et après 
         +-->
    <xsl:template name="further">
    	<xsl:param name="truelevel"/>
        
        <!-- Poursuite d'étude -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/furtherStudy"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_FURTHER_STUDY'"/>
        </xsl:call-template>
        
        <!-- Poursuite d'études à l'étranger -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/studyAbroad"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_STUDY_ABROAD'"/>
        </xsl:call-template>
        
        <!-- Insertion professionnelle -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/jobOpportunities"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_PRO_INSERTION'"/>
        </xsl:call-template>
        
        <!-- Passerelles et ré orientation -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/reorientation"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_REORIENTATION'"/>
        </xsl:call-template>
        
        <!-- Référenciels ROME -->
        <xsl:if test="metadata/romeCode">
        	<fo:block>
	            <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	            <i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_ROME_TITLE"/>
	        </fo:block>
	        <fo:list-block>
	        	<xsl:call-template name="ul-style">
        			<xsl:with-param name="mark" select="@mark"/>
        		</xsl:call-template>
        	
	        	<xsl:for-each select="metadata/romeCode">
	        		<fo:list-item>
			            <fo:list-item-label>
			                <fo:block>* </fo:block>
			            </fo:list-item-label>
			            <fo:list-item-body start-indent="body-start()-5mm">
			                <fo:block><xsl:value-of select="concat(odf:getCode(@id), ': ', @title)"/></fo:block>
			            </fo:list-item-body>
			        </fo:list-item>
	        	</xsl:for-each>
	        </fo:list-block>
      	</xsl:if>     
    </xsl:template>
    
    <!-- +
         | TAB 05: Contacts
         +-->
	<xsl:template name="contacts">
    	<xsl:param name="truelevel"/>
        
        <!-- Composante -->
        <xsl:if test="metadata/orgUnit">
         	 <fo:block>
	        	 <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_ORGUNIT"/>
	         </fo:block>
             <xsl:for-each select="metadata/orgUnit">
                <fo:block><xsl:value-of select="@title"/></fo:block>  
            </xsl:for-each>    
         </xsl:if>
         
         <!-- Lieu de la formation -->
         <xsl:if test="metadata/place">
	         <fo:block>
	        	 <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PLACE"/>
	         </fo:block>
	         <fo:block>
                <xsl:for-each select="metadata/place">
                	<xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>
                </xsl:for-each>
	         </fo:block>
	     </xsl:if>
         
         <!-- Campus -->
         <xsl:if test="metadata/campus">
	         <fo:block>
	        	 <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template>
	            <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PLACE"/>
	         </fo:block>
	         <fo:block>
                <xsl:for-each select="metadata/campus">
                	<xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>
                </xsl:for-each>
	         </fo:block>
	     </xsl:if>
        
         <!-- Contact(s) -->
         <xsl:call-template name="contacts-persons">
         	<xsl:with-param name="truelevel" select="$truelevel + 1"/>
         </xsl:call-template>
         
         <!-- Autres Contacts-->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/otherContact"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_OTHER_CONTACT'"/>
         </xsl:call-template> 
    </xsl:template>
    
	<xsl:template name="right-content">
		<xsl:param name="truelevel"/>
		
		<xsl:call-template name="joint-orgunit">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
		<xsl:call-template name="infos">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="more-info">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="partner-laboratories">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="partner-schools">
            <xsl:with-param name="truelevel" select="$truelevel"/>        
        </xsl:call-template>
        
        <!-- Autre(s) structure(s) partenaire(s) -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/otherPartners"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'PLUGINS_ODF_PROGRAM_OTHER_PARTNERS'"/>
        </xsl:call-template> 
        
	</xsl:template>
	
	<!-- +
         | RIGHT CONTENT : Etablissement
         + -->
    <xsl:template name="joint-orgunit">
        <xsl:param name="truelevel"/>
        
        <xsl:if test="metadata/jointOrgUnit">
	        <fo:block xsl:use-attribute-sets="right-block">
				<fo:block xsl:use-attribute-sets="right-block-header">
	                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_JOINT_ORGUNIT"/>
	            </fo:block>
	            <fo:list-block>
	            	<xsl:for-each select="metadata/jointOrgUnit">
	            		<fo:list-item>
				            <fo:list-item-label><fo:block>* </fo:block></fo:list-item-label>
				            <fo:list-item-body start-indent="body-start()-5mm"><fo:block><xsl:value-of select="@title"/></fo:block></fo:list-item-body>
			       	 	</fo:list-item>
	            	</xsl:for-each>
	            </fo:list-block>
	        </fo:block>
	    </xsl:if>
    </xsl:template>    
	
	<!-- +
         | RIGHT CONTENT : Plus d'infos
         + -->
	<xsl:template name="infos">
		<xsl:param name="truelevel"/>
		
		<fo:block xsl:use-attribute-sets="right-block">
			<fo:block xsl:use-attribute-sets="right-block-header">
                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_MORE_INFO"/>
            </fo:block>
            <fo:block xsl:use-attribute-sets="right-block-body">
            	<!-- Nombre de crédits ECTS -->
            	<xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_ECTS'"/>
               		<xsl:with-param name="value" select="metadata/ects/@title"/>
               	</xsl:call-template>
	
				<!-- Durée -->
				<xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_DURATION'"/>
               		<xsl:with-param name="value" select="metadata/duration/@title"/>
               	</xsl:call-template>
	
				<!-- Niveau d'étude -->
				<xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_LEVEL'"/>
               		<xsl:with-param name="value" select="metadata/educationLevel/@title"/>
               	</xsl:call-template>
                
				<!-- Public concerné (formation initiale, continue, ...) -->
                <xsl:if test="metadata/formofteachingOrg">
                    <fo:block>
                        <xsl:call-template name="para-style"/>
                        
                        <fo:block font-weight="bold">
                            <i18n:text>
                                <xsl:attribute name="i18n:catalogue">plugin.odf</xsl:attribute>
                                <xsl:attribute name="i18n:key">CONTENT_PROGRAM_EDUCATION_TYPE</xsl:attribute>
                            </i18n:text>
                        </fo:block>
                        <fo:list-block>
                            <xsl:for-each select="metadata/formofteachingOrg[@title]">
                                <fo:list-item>
                                    <fo:list-item-label><fo:block>* </fo:block></fo:list-item-label>
                                    <fo:list-item-body start-indent="body-start()-5mm"><fo:block><xsl:value-of select="@title"/></fo:block></fo:list-item-body>
                                </fo:list-item>
                            </xsl:for-each>
                        </fo:list-block>
                    </fo:block>
                </xsl:if>
				
	            <!-- Formation à distance -->
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_DISTANCE_LEARNING'"/>
               		<xsl:with-param name="value" select="metadata/distanceLearning/@title"/>
               	</xsl:call-template>
					
	            <!-- Nature de la formation -->
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_EDUCATION_KIND'"/>
               		<xsl:with-param name="value" select="metadata/educationKind/@title"/>
               	</xsl:call-template>
				
	            <!-- Langue d'enseignement -->
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_EDUCATION_LANGUAGE'"/>
               		<xsl:with-param name="value" select="metadata/educationLanguage"/>
               	</xsl:call-template>
               	<fo:block>
	            	<xsl:call-template name="para-style"/>
	                <xsl:if test="normalize-space(metadata/educationLanguage/@title) != ''">
	            	   <fo:inline font-weight="bold">
	                		 <i18n:text>
                                <xsl:attribute name="i18n:catalogue">plugin.odf</xsl:attribute>
                                <xsl:attribute name="i18n:key">CONTENT_PROGRAM_EDUCATION_LANGUAGE</xsl:attribute>
                            </i18n:text>
	    	                <xsl:text> : </xsl:text>
	    	            </fo:inline>
	                </xsl:if>
	                <xsl:for-each select="metadata/educationLanguage">
							<xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>			
						</xsl:for-each>
	            </fo:block>
				
	            <!-- Effectif -->	
               	<xsl:call-template name="common-content-richtext2pdf-field">
		             <xsl:with-param name="value" select="metadata/numberOfStudents"/>
		             <xsl:with-param name="level" select="$truelevel + 1"/>
		             <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_NUMBER_OF_STUDENTS'"/>
		         </xsl:call-template> 
				
	            <!-- Stage -->
	            <xsl:variable name="internship"><xsl:value-of select="metadata/internship/@title"/><xsl:if test="normalize-space(metadata/internshipDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipDuration"/><xsl:text>)</xsl:text></xsl:if></xsl:variable>
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_INTERNSHIP'"/>
               		<xsl:with-param name="value" select="$internship"/>
               	</xsl:call-template>
				
	            <!-- Stage à l'étranger -->
	            <xsl:variable name="internshipAbroad"><xsl:value-of select="metadata/internshipAbroad/@title"/><xsl:if test="normalize-space(metadata/internshipAbroadDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipAbroadDuration"/><xsl:text>)</xsl:text></xsl:if></xsl:variable>
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_INTERNSHIP'"/>
               		<xsl:with-param name="value" select="$internshipAbroad"/>
               	</xsl:call-template>
				
	            <!-- Taux de réussite -->
	            <xsl:call-template name="common-content2pdf-right-block">
               		<xsl:with-param name="label" select="'plugin.odf:CONTENT_PROGRAM_SUCCESS_RATE'"/>
               		<xsl:with-param name="value" select="metadata/successRate"/>
               	</xsl:call-template>
            </fo:block>
		</fo:block>
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Plus d'infos
	     + -->
	<xsl:template name="more-info">
        <xsl:param name="truelevel"/>
        
    	<xsl:if test="normalize-space(metadata/programWebSiteUrl) != ''">
			<fo:block xsl:use-attribute-sets="right-block">
				<fo:block xsl:use-attribute-sets="right-block-header">
	                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_WEB_LINK_TITLE"/>
	            </fo:block>
	            <fo:block xsl:use-attribute-sets="right-block-body">
	            	<xsl:variable name="displayedlabel">
                            <xsl:choose>
                                <xsl:when test="normalize-space(metadata/programWebSiteLabel) != ''"><xsl:value-of select="metadata/programWebSiteLabel"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="metadata/programWebSiteUrl"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <fo:block>
                            <xsl:call-template name="link-style"><xsl:with-param name="class" select="'external'"/></xsl:call-template>
                            <fo:basic-link external-destination="url('{metadata/programWebSiteUrl}')"><xsl:value-of select="$displayedlabel"/></fo:basic-link>
                        </fo:block>
				</fo:block>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Laboratoires partenaires
	     + -->
	<xsl:template name="partner-laboratories">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/partnerLaboratories/entry/*">
			<fo:block xsl:use-attribute-sets="right-block">
				<fo:block xsl:use-attribute-sets="right-block-header">
	                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PARTNER_LABORATORIES"/>
	            </fo:block>
	            <fo:block xsl:use-attribute-sets="right-block-body">
	            	 <xsl:for-each select="metadata/partnerLaboratories/entry">
                         <xsl:variable name="label">
                             <xsl:choose>
                                 <xsl:when test="linkLabel"><xsl:value-of select="linkLabel"/></xsl:when>
                                 <xsl:otherwise><xsl:value-of select="linkUrl"/></xsl:otherwise>
                             </xsl:choose>
                         </xsl:variable>
                         <fo:block>
                             <xsl:call-template name="link-style"><xsl:with-param name="class" select="'external'"/></xsl:call-template>
                             <fo:basic-link external-destination="url('{linkUrl}')"><xsl:value-of select="$label"/></fo:basic-link>
                         </fo:block>
                     </xsl:for-each>
				</fo:block>
			</fo:block>
		</xsl:if>	
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Etablissements partenaires
	     + -->
	<xsl:template name="partner-schools">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/partnerSchools/entry/*">
			<fo:block xsl:use-attribute-sets="right-block">
				<fo:block xsl:use-attribute-sets="right-block-header">
	                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PARTNER_SCHOOLS"/>
	            </fo:block>
	            <fo:block xsl:use-attribute-sets="right-block-body">
					<xsl:for-each select="metadata/partnerSchools/entry">
						<xsl:variable name="label">
                             <xsl:choose>
                                 <xsl:when test="linkLabel"><xsl:value-of select="linkLabel"/></xsl:when>
                                 <xsl:otherwise><xsl:value-of select="linkUrl"/></xsl:otherwise>
                             </xsl:choose>
                         </xsl:variable>
                         <fo:block>
                             <xsl:call-template name="link-style"><xsl:with-param name="class" select="'external'"/></xsl:call-template>
                             <fo:basic-link external-destination="url('{linkUrl}')"><xsl:value-of select="$label"/></fo:basic-link>
                         </fo:block>
					</xsl:for-each>
				</fo:block>
			</fo:block>
		</xsl:if>	
	</xsl:template>
	
	<!-- +
		 | Contacts
		 + -->
    <xsl:template name="contacts-persons">
    	<xsl:param name="truelevel"/>
    	
    	<xsl:if test="metadata/contacts/entry">
	    	<fo:block>
		       	 <xsl:call-template name="title-style">
		           	<xsl:with-param name="level" select="$truelevel"/>
		         </xsl:call-template>
		         <i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_CONTACTS"/>
		 	</fo:block>
            
		    <xsl:for-each select="metadata/contacts/entry">
                <xsl:if test="normalize-space(role/@title) != ''">
                    <fo:block>
    			       	 <xsl:call-template name="title-style">
    			           	<xsl:with-param name="level" select="$truelevel+1"/>
    			         </xsl:call-template>
    			         <xsl:value-of select="role/@title"/>
    			 	</fo:block>
                </xsl:if>
                
                <xsl:for-each select="persons">
                    <xsl:variable name="personId" select="@id"/>
                    <xsl:variable name="content" select="//persons/content[@id = $personId]/content"/>
                    
    		    	<!-- Nom -->
    		        <xsl:if test="normalize-space($content/metadata/givenName) != '' or normalize-space($content/metadata/lastName) != ''">
    		            <fo:block>
                            <xsl:if test="normalize-space($content/metadata/personTitle) != ''">
                                <xsl:value-of select="$content/metadata/personTitle"/><xsl:text> </xsl:text>
                            </xsl:if>
                            <xsl:value-of select="concat($content/metadata/lastName, ' ', $content/metadata/givenName)"/>
                        </fo:block>
    		        </xsl:if>
    		        
    		        <!-- Email -->
    		        <xsl:if test="normalize-space($content/metadata/mail) != ''">
    		            <fo:block><xsl:value-of select="$content/metadata/mail"/></fo:block>
    		        </xsl:if>
    		        
    		        <!-- Téléphone -->
    		        <xsl:if test="normalize-space($content/metadata/phone) != ''">
    		            <fo:block>
    		                <i18n:text i18n:key="PLUGINS_ODF_PROGRAM_PHONE" i18n:catalogue="plugin.odf"/>
    		                <xsl:value-of select="$content/metadata/phone"/>
    		            </fo:block>
    		        </xsl:if> 
    		        
    		        <!-- Fax -->
    		        <xsl:if test="normalize-space($content/metadata/fax) != ''">
    		            <fo:block>
    		                <i18n:text i18n:key="PLUGINS_ODF_PROGRAM_FAX" i18n:catalogue="plugin.odf"/>
    		                <xsl:value-of select="$content/metadata/fax"/>
    		            </fo:block>
    		        </xsl:if> 
    		        
    		        <!-- Lien -->
    		        <xsl:if test="normalize-space($content/metadata/webLinkUrl) != ''">
    		            <xsl:variable name="label">
    		                <xsl:choose>
    		                    <xsl:when test="$content/metadata/webLinkLabel"><xsl:value-of select="content/metadata/webLinkLabel"/></xsl:when>
    		                    <xsl:otherwise><xsl:value-of select="$content//metadata/webLinkUrl"/></xsl:otherwise>
    		                </xsl:choose>
    		            </xsl:variable>
    		            <fo:block>
    		                <xsl:call-template name="link-style"><xsl:with-param name="class" select="'external'"/></xsl:call-template>
    		                <fo:basic-link external-destination="url('{$content/metadata/webLinkUrl}')"><xsl:value-of select="$label"/></fo:basic-link>
    		            </fo:block>
    		        </xsl:if>
    		        <xsl:if test="position() != last()"><fo:block>&#160;</fo:block></xsl:if>
                </xsl:for-each>
	        </xsl:for-each>    
		</xsl:if>
    </xsl:template>
    
   	<!-- +
         | SUBPROGRAM
         + -->
	<xsl:template match="subprogram">
        <fo:list-item>
		  	<fo:list-item-label><fo:block>-</fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="10pt"><fo:block><xsl:value-of select="content/content/metadata/title"/></fo:block></fo:list-item-body>
        </fo:list-item>
	</xsl:template>
	
	<!-- +
         | CONTAINERS
         + -->
	<xsl:template match="container">
		<xsl:param name="level" select="0"/>
        <xsl:param name="indent" select="0"/>
        
        <fo:list-item>
		  	<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="{$indent}pt">
		  		<fo:block>
		  			<xsl:call-template name="li-text-style-container">
		  				<xsl:with-param name="level" select="$level"/>
		  			</xsl:call-template>
		  			<xsl:value-of select="@title"/>
		  		</fo:block>
		  		<xsl:if test="subprogram|container|courseList">
		  			<fo:block>
				  		<fo:list-block space-before="8pt" start-indent="{$indent}pt">
				  			<xsl:call-template name="ol-style"/>
							<xsl:apply-templates select="subprogram|container|courseList">
								<xsl:with-param name="indent" select="$indent + 10"/>
								<xsl:with-param name="level" select="$level + 1"/>
							</xsl:apply-templates>
						</fo:list-block>
		  			</fo:block>
		  		</xsl:if>
		  	</fo:list-item-body>
        </fo:list-item>
	</xsl:template>
	
	<!-- +
         | COURSE LIST
         + -->
	<xsl:template match="courseList">
        <xsl:param name="indent" select="0"/>
        <xsl:param name="level" select="0"/>
        
        <fo:list-item>
            <fo:list-item-label><fo:block></fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="{$indent}pt">
		  		<fo:block>
		  			<xsl:call-template name="li-text-style-courselist">
		  				<xsl:with-param name="level" select="$level"/>
		  			</xsl:call-template>
		  			<fo:inline>
                        <xsl:text> - </xsl:text><xsl:value-of select="@title"/>
    		  			<xsl:if test="@type = 'MANDATORY'">
                            <fo:inline> (<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_MANDATORY" i18n:catalogue="plugin.odf"/>)</fo:inline>
                        </xsl:if>
    					<xsl:if test="@type = 'OPTIONAL'">
                            <fo:inline> (<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_OPTIONAL" i18n:catalogue="plugin.odf"/>)</fo:inline>
                        </xsl:if>
    		  			<xsl:if test="@type = 'CHOICE'">
                            <fo:inline>
                                <xsl:text> (</xsl:text><i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_CHOICE" i18n:catalogue="plugin.odf"/>:&#160;
                                <xsl:value-of select="@min"/>&#160;<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_MAX_ELP" i18n:catalogue="plugin.odf"/>&#160;
                                <xsl:value-of select="@max"/><xsl:text>)</xsl:text>
                            </fo:inline>
                        </xsl:if>
                    </fo:inline>
                    
                    <xsl:if test="course">
						<fo:list-block start-indent="{$indent}pt">	
							<xsl:call-template name="ol-style"/>
							<xsl:apply-templates select="course">
								<xsl:with-param name="indent" select="$indent + 10"/>
								<xsl:with-param name="level" select="$level + 1"/>
							</xsl:apply-templates>
						</fo:list-block>
					</xsl:if>
		  		</fo:block>
			</fo:list-item-body>
        </fo:list-item>
	</xsl:template>
	
	<!-- +
		 | COURSE
		 + -->
	<xsl:template match="course">
		<xsl:param name="indent" select="0"/>
		<xsl:param name="level" select="0"/>
		
		 <fo:list-item>
		  	<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="{$indent}pt"> 
		  		<fo:block>
		  			<xsl:call-template name="li-text-style-course">
		  				<xsl:with-param name="level" select="$level"/>
		  			</xsl:call-template>
					<fo:inline>
                        <xsl:text>&#183; </xsl:text><xsl:value-of select="@title"/>
    					<xsl:if test="@ects != '' and @ects != '0'">
                            <xsl:text> (</xsl:text><xsl:value-of select="@ects"/><xsl:text> ECTS)</xsl:text>
                        </xsl:if>
                    </fo:inline>
				</fo:block>
				<xsl:if test="courseList">
			  		<fo:block padding-bottom="8pt">
						<fo:list-block start-indent="{$indent + 10}pt">
							<xsl:call-template name="ol-style"/>
							<xsl:apply-templates select="courseList">
								<xsl:with-param name="indent" select="$indent + 10"/>
								<xsl:with-param name="level" select="$level + 1"/>
							</xsl:apply-templates>
						</fo:list-block>
					</fo:block>
				</xsl:if>
			</fo:list-item-body>
		</fo:list-item>
	</xsl:template>
    
    <xsl:template name="subprogram-content">
        <xsl:for-each select="subprogram/content/content">
            <fo:block break-before="page"/>
            
            <fo:block role="heading">
	            <xsl:call-template name="title-style">
	            	<xsl:with-param name="level" select="2"/>
	            </xsl:call-template>
	           	<xsl:value-of select="metadata/title"/>
	        </fo:block>
        
            <fo:block space-before="0.5cm">
	            <fo:table table-layout="fixed">
	                <fo:table-column column-width="13cm"/>
	                <fo:table-column column-width="6cm"/>
	                <fo:table-body>
	                    <fo:table-row>
	                        <fo:table-cell margin-left="0cm" margin-right="0cm">
	                            <fo:block>
                                	<xsl:call-template name="body-content">
                                		<xsl:with-param name="truelevel" select="2"/>
                                	</xsl:call-template>
                                </fo:block>
	                        </fo:table-cell>
	                        <fo:table-cell margin-left="0cm" margin-right="0cm" padding-left="3pt">
	                            <fo:block>
	                            	<xsl:call-template name="right-content">
	                            		<xsl:with-param name="truelevel" select="2"></xsl:with-param>
	                            	</xsl:call-template>
	                            </fo:block>
	                        </fo:table-cell>
	                    </fo:table-row>
	                </fo:table-body>
	            </fo:table>
        	</fo:block>
        </xsl:for-each>
    </xsl:template>
    
    <!-- +
         | Default style
         + -->
    <xsl:template name="region-body-definition"/>
    
    <xsl:template name="region-before-definition"/>
    
    <xsl:template name="region-after-definition"/>
    
    <xsl:template name="main-body-block"/>
    
    <xsl:template name="main-region-after-block">
        <xsl:attribute name="font-size">9px</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-body-style"/>
    
    
    <xsl:attribute-set name="brief"/>
    <xsl:attribute-set name="brief-title"/>
    
    <xsl:attribute-set name="right-block"/>
    <xsl:attribute-set name="right-block-body"/>
    <xsl:attribute-set name="right-block-header"/>
    
    <xsl:template name="li-text-style-container">
		<xsl:param name="level"/>
	</xsl:template>
	<xsl:template name="li-text-style-courselist">
		<xsl:param name="level"/>
	</xsl:template>
	<xsl:template name="li-text-style-course">
		<xsl:param name="level"/>
	</xsl:template>
    
</xsl:stylesheet>
