/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf;

import java.util.ArrayList;
import org.ametys.cms.content.RootContentHelper;
import org.ametys.cms.test.framework.WithCmsFeaturesTestCase;
import org.ametys.core.right.Profile;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.runtime.test.SimpleUserProvider;
import org.ametys.runtime.test.framework.AbstractPopulationAwareTestCase;
import org.ametys.runtime.test.framework.CocoonTestCase;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

@CocoonTestCase.NeedFeatures(value={"cms/root.content.helper", "core/runtime.rights.profiles.dao", "test/test.user.provider", "cms/workflow.reference.table", "odf/workflow.program", "odf/workflow.subprogram", "odf/workflow.container", "odf/workflow.courselist", "odf/workflow.course", "odf/workflow.course.part", "odf/workflow.orgunit", "odf/workflow.person"})
public abstract class AbstractODFTestCase
extends AbstractPopulationAwareTestCase
implements WithCmsFeaturesTestCase {
    protected static final String PROFILE_ID = "profile-odf-test";
    protected static SimpleUserProvider _currentUserProvider;
    protected static ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected static RightProfilesDAO _profilesDAO;
    protected static RootContentHelper _rootContentHelper;

    public void lookupComponents(ServiceManager manager) throws ServiceException {
        super.lookupComponents(manager);
        _currentUserProvider = (SimpleUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        _profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        _profilesDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        _rootContentHelper = (RootContentHelper)manager.lookup(RootContentHelper.ROLE);
    }

    public void prepareComponents() throws Exception {
        super.prepareComponents();
        _currentUserProvider.setUser(USER1_TEST_IDENTITY);
        AmetysObjectCollection rootOfContents = _rootContentHelper.getRootContent();
        _profileAssignmentStorageEP.allowProfileToAnyConnectedUser("READER", (Object)rootOfContents);
        Profile profile = _profilesDAO.addProfile(PROFILE_ID);
        ArrayList<String> rightsNeeded = new ArrayList<String>();
        rightsNeeded.add("Workflow_Rights_Restore");
        rightsNeeded.add("Workflow_Rights_Archive");
        rightsNeeded.add("Workflow_Rights_Unarchive");
        rightsNeeded.add("Workflow_Rights_Edition_Online");
        rightsNeeded.add("Workflow_Rights_Validate");
        rightsNeeded.add("Workflow_Rights_Propose");
        rightsNeeded.add("Workflow_Rights_Refuse");
        rightsNeeded.add("ODF_Rights_OrgUnit_Edit");
        rightsNeeded.add("ODF_Rights_OrgUnit_Synchro");
        rightsNeeded.add("ODF_Rights_OrgUnit_Validate");
        rightsNeeded.add("ODF_Rights_OrgUnit_Propose");
        rightsNeeded.add("ODF_Rights_OrgUnit_Refuse");
        rightsNeeded.add("ODF_Rights_Program_Edit");
        rightsNeeded.add("ODF_Rights_Program_Synchro");
        rightsNeeded.add("ODF_Rights_Program_Validate");
        rightsNeeded.add("ODF_Rights_Program_Validate_Global");
        rightsNeeded.add("ODF_Rights_Program_Propose");
        rightsNeeded.add("ODF_Rights_Program_Refuse");
        rightsNeeded.add("ODF_Rights_SubProgram_Edit");
        rightsNeeded.add("ODF_Rights_SubProgram_Synchro");
        rightsNeeded.add("ODF_Rights_Container_Edit");
        rightsNeeded.add("ODF_Rights_Container_Synchro");
        rightsNeeded.add("ODF_Rights_CourseList_Edit");
        rightsNeeded.add("ODF_Rights_CourseList_Synchro");
        rightsNeeded.add("ODF_Rights_Course_Edit");
        rightsNeeded.add("ODF_Rights_Course_Synchro");
        rightsNeeded.add("ODF_Rights_Course_Validate");
        rightsNeeded.add("ODF_Rights_Course_Propose");
        rightsNeeded.add("ODF_Rights_Course_Refuse");
        rightsNeeded.add("ODF_Rights_Person_Edit");
        rightsNeeded.add("ODF_Rights_Person_Synchro");
        rightsNeeded.add("ODF_Rights_Person_Validate");
        rightsNeeded.add("ODF_Rights_Strategics_Fields");
        _profilesDAO.addRights(profile, rightsNeeded);
        _profileAssignmentStorageEP.allowProfileToUser(USER1_TEST_IDENTITY, profile.getId(), (Object)"/test");
        _profileAssignmentStorageEP.allowProfileToUser(USER1_TEST_IDENTITY, profile.getId(), (Object)"/cms");
        _profileAssignmentStorageEP.allowProfileToUser(USER1_TEST_IDENTITY, profile.getId(), (Object)"/odf");
    }
}

