/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import java.util.List;
import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.odf.CopyODFUpdater;

/**
 * Interface to update contents after a copy of ODF catalog
 */
public interface CopyCatalogUpdater extends CopyODFUpdater
{
    /**
     * Get the additional contents of the catalog
     * @param catalogName the catalog name
     * @return additional contents managed by the updater
     */
    public default List<Content> getAdditionalContents(String catalogName)
    {
        return List.of();
    }
    
    /**
     * Copy additional contents from the initial to the new catalog
     * @param initialCatalogName the name of initial catalog
     * @param newCatalogName the name of new catalog
     * @param copiedContents the initial contents with their copied content
     */
    public default void copyAdditionalContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents)
    {
        // Nothing to do by default
    }
}
