/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.ModifiableContentFactory;
import org.ametys.odf.orgunit.RootOrgUnitProvider;

/**
 * {@link ModifiableContentFactory} for handling {@link ProgramPart}
 */
public class ProgramPartFactory extends ModifiableContentFactory
{
    private RootOrgUnitProvider _rootOrgUnitProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) manager.lookup(RootOrgUnitProvider.ROLE);
    }
    
    String _getRootOrgUnitRNE()
    {
        return _rootOrgUnitProvider.getRoot().getUAICode();
    }
}
