/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program.properties;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.model.properties.AbstractIndexableStaticProperty;
import org.ametys.cms.model.properties.Property;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link Property} which represents the shared status of a {@link ProgramItem}.
 */
public class SharedProperty extends AbstractIndexableStaticProperty<Boolean, Boolean, Content>
{
    private ODFHelper _odfHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
    }
    
    public Object getValue(Content content)
    {
        if (content instanceof ProgramItem programItem)
        {
            return _odfHelper.isShared(programItem);
        }
        
        return false;
    }
    
    @Override
    protected String getTypeId()
    {
        return ModelItemTypeConstants.BOOLEAN_TYPE_ID;
    }
}
