/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool is a tool that display a tree of the current selected ELP.
 */
Ext.define('Ametys.plugins.odf.course.CourseTreeTool', {
	extend: "Ametys.plugins.odf.tree.AbstractODFTreeTool",
    
    /**
     * @property {String[]} _openableTypes The list of content types to open on double-click
     * @private
     */
    _openableTypes: ['org.ametys.plugins.odf.Content.course'],
    
    getOpenableContentTypes: function()
    {
        return this._openableTypes;
    },
    
    _getPathInTree: function(contentId, rootId, callback, scope)
    {
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.ODFHelper",
            methodName: "getPathInCourse",
            parameters: [contentId, rootId],
            callback: {
                handler: callback,
                scope: scope || this
            },
            waitMessage: false
        });
    }
});