<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">

    <xsl:import href="view:cms://stylesheets/content/common.xsl"/>
    <xsl:import href="plugin:odf://stylesheets/content/common.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">odfperson</xsl:variable>
	
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
    	<xsl:variable name="title">
	    	<xsl:choose>
	    		<xsl:when test="metadata/lastName != '' or metadata/givenName != ''">
                    <xsl:if test="metadata/personTitle != ''">
                        <xsl:value-of select="metadata/personTitle"/><xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="concat(metadata/lastName, ' ', metadata/givenName)"/>
                </xsl:when>
	    		<xsl:otherwise><xsl:value-of select="metadata/title"/></xsl:otherwise>
	    	</xsl:choose>
	    </xsl:variable>
        <xsl:call-template name="common-content-head-title-content">
            <xsl:with-param name="title" select="$title"/>
        </xsl:call-template>
    </xsl:template> 
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title">
    	<xsl:variable name="title">
	    	<xsl:choose>
	    		<xsl:when test="metadata/lastName != '' or metadata/givenName != ''">
                    <xsl:if test="metadata/personTitle != ''">
                        <xsl:value-of select="metadata/personTitle"/><xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="concat(metadata/lastName, ' ', metadata/givenName)"/>
                </xsl:when>
	    		<xsl:otherwise><xsl:value-of select="metadata/title"/></xsl:otherwise>
	    	</xsl:choose>
	    	</xsl:variable>
        <xsl:call-template name="common-content-body-title-content">
            <xsl:with-param name="title" select="$title"/>
        </xsl:call-template>
    </xsl:template> 
    
    <xsl:template name="person-role">
        <xsl:if test="normalize-space(metadata/role) != ''">
            <p class="role"><xsl:value-of select="metadata/role"/></p>
        </xsl:if>    
    </xsl:template>     
    
    <xsl:template name="person-address">
        <xsl:if test="normalize-space(metadata/address) != '' or normalize-space(metadata/additionalAddress) != '' or normalize-space(metadata/zipCode) != '' or normalize-space(metadata/town) != ''">
            <p class="address">
	            <span class="element-name">
	            	<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_ADDRESS"/>
	            </span>
                <xsl:text> </xsl:text>
                <span class="element-value">
	                <xsl:if test="normalize-space(metadata/address) != ''"><xsl:value-of select="metadata/address"/><br/></xsl:if>
	                <xsl:if test="normalize-space(metadata/additionalAddress) != ''"><xsl:value-of select="metadata/additionalAddress"/><br/></xsl:if>
	                <xsl:if test="normalize-space(metadata/zipCode) != ''"><xsl:value-of select="metadata/zipCode"/><xsl:text> </xsl:text></xsl:if>
	                <xsl:if test="normalize-space(metadata/town) != ''"><xsl:value-of select="metadata/town"/></xsl:if>
	            </span>
            </p>
        </xsl:if>         
    </xsl:template>       
    
    <xsl:template name="person-mail">
        <xsl:if test="normalize-space(metadata/mail) != ''">
            <p class="mail">
                <span class="element-name">
                	<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_EMAIL"/>
                </span>
                <xsl:text> </xsl:text>
                <span class="element-value">
                	<xsl:call-template name="mail-antispam">
                		<xsl:with-param name="mail" select="metadata/mail"/>
                	</xsl:call-template>
                </span>
            </p>        
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="person-mobile">
        <xsl:if test="normalize-space(metadata/phone) != ''">
            <p class="telephone">
                <span class="element-name">
                	<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_MOBILE"/>
                </span>
                <xsl:text> </xsl:text>
                <span class="element-value"><xsl:value-of select="metadata/phone"/></span>
            </p>        
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="person-fax">
        <xsl:if test="normalize-space(metadata/fax) != ''">
            <p class="fax">
                <span class="element-name">
                	<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_FAX"/>
                </span>
                <xsl:text> </xsl:text>
                <span class="element-value"><xsl:value-of select="metadata/fax"/></span>
            </p>             
        </xsl:if>
    </xsl:template>
	
    <xsl:template name="person-website">
        <xsl:if test="normalize-space(metadata/webLinkUrl)">
            <p class="website">
                <span class="element-name">
                	<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_WEBSITE"/>
                </span>            
                <span class="element-value">
	                <a href="{metadata/webLinkUrl}" class="external">
    	                <xsl:choose>
        	                <xsl:when test="metadata/webLinkLabel != ''"><xsl:value-of select="metadata/webLinkLabel"/></xsl:when>
            	            <xsl:otherwise><xsl:value-of select="metadata/webLinkUrl"/></xsl:otherwise>
                	    </xsl:choose>
                	</a>
                </span>
            </p>
        </xsl:if>
    </xsl:template>
        
    <xsl:template name="person-infos">
        <xsl:param name="truelevel"/>
    
    	<xsl:call-template name="common-content-richtext-field">
            <xsl:with-param name="value" select="metadata/additionalInformations"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_ODFPERSON_MORE_INFOS'"/>
        </xsl:call-template> 
    </xsl:template>        

</xsl:stylesheet>