<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/"
                xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="docbook">

    <xsl:variable name="nl"><xsl:text>
</xsl:text></xsl:variable>
    <xsl:variable name="sautdebloc">#SAUTDEBLOC#</xsl:variable>
    
    <xsl:template match="docbook:article">
        <xsl:apply-templates>
            <xsl:with-param name="level" select="1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="docbook:phrase[@role='linebreak']"><xsl:text>
</xsl:text>
    </xsl:template>
    
    <xsl:template match="docbook:section">
        <xsl:param name="level"/>
        
        <xsl:if test="docbook:title/node()">
            <xsl:element name="title{$level}">
                <xsl:attribute name="aid:pstyle">SPTitle<xsl:value-of select="$level"/></xsl:attribute>
                <xsl:apply-templates select="docbook:title/node()"/>
            </xsl:element><xsl:text>
</xsl:text>
        </xsl:if>
        <xsl:apply-templates select="*[name() != 'section' and name() != 'title']"/>
        <xsl:apply-templates select="docbook:section">
            <xsl:with-param name="level" select="$level+1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="docbook:para"><xsl:apply-templates/><xsl:text>
</xsl:text>
    </xsl:template>
    
    <xsl:template match="docbook:itemizedlist"><xsl:apply-templates mode="unorderedlist"/></xsl:template>
    
    <xsl:template match="docbook:orderedlist"><xsl:apply-templates mode="orderedlist"/></xsl:template>
    
    <xsl:template match="docbook:listitem" mode="unorderedlist"><xsl:text> - </xsl:text><xsl:apply-templates/></xsl:template>
    
    <xsl:template match="docbook:listitem" mode="orderedlist"><xsl:value-of select="position()"/><xsl:text>. </xsl:text><xsl:apply-templates/></xsl:template>
    
    <xsl:template match="docbook:emphasis">
        <xsl:choose>
            <xsl:when test="@role='strong'">
                <gras aid:cstyle="SCGras"><xsl:apply-templates/></gras>
            </xsl:when>
            <xsl:otherwise>
                <italique aid:cstyle="SCItalique"><xsl:apply-templates/></italique>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="docbook:link"><lien aid:cstyle="SCLien"><xsl:apply-templates/></lien></xsl:template>
    
    <!-- Unsupported styles -->
    <xsl:template match="docbook:subscript|docbook:supscript|docbook:acronym|docbook:abbrev|docbook:quote|docbook:foreignphrase"><xsl:apply-templates/></xsl:template>
    
    <xsl:template match="docbook:imageobject"/>
    
    <xsl:template match="docbook:mediaobject"/>
    
    <xsl:template match="text()"><xsl:value-of select="normalize-space(.)"/></xsl:template>
    
    
    <xsl:template match="content" mode="contact">
        <xsl:if test="normalize-space(metadata/givenName) != '' or normalize-space(metadata/lastName) != ''">
            <xsl:if test="normalize-space(metadata/personTitle) != ''">
                <xsl:value-of select="metadata/personTitle"/>
                <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="concat(metadata/givenName, ' ', metadata/lastName)"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        <xsl:if test="normalize-space(metadata/phone) != ''">
            <xsl:value-of select="metadata/phone"/><xsl:value-of select="$nl"/>
        </xsl:if>
        <xsl:if test="normalize-space(metadata/mail) != ''">
            <xsl:value-of select="metadata/mail"/><xsl:value-of select="$nl"/>
        </xsl:if>
        <xsl:value-of select="$nl"/>
    </xsl:template>
</xsl:stylesheet>