/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.course;

import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.odf.bean.AbstractExternalAddress;
import org.ametys.odf.cdmfr.CDMFRTagsConstants;

/**
 * LOM Sheet object
 */
public class LOMSheet extends AbstractExternalAddress
{
    /**
     * Constructor
     * @param url URL of the LOM sheet
     * @param label Label of the LOM sheet
     */
    public LOMSheet(String url, String label)
    {
        super(url, label);
    }

    /**
     * Transform the LOM sheet to CDM
     * @param contentHandler the content handler to sax into
     * @throws SAXException if an error occurred while saxing
     */
    public void toCDM(ContentHandler contentHandler) throws SAXException
    {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute(CDMFRTagsConstants.ATTRIBUTE_ROLE, "learningObjectMetadata");
        XMLUtils.startElement(contentHandler, CDMFRTagsConstants.TAG_WEB_LINK, attrs);
        if (StringUtils.isNotEmpty(getUrl()))
        {
            XMLUtils.createElement(contentHandler, CDMFRTagsConstants.TAG_HREF, getUrl());
        }
        if (StringUtils.isNotEmpty(getLabel()))
        {
            XMLUtils.createElement(contentHandler, CDMFRTagsConstants.TAG_LINK_NAME, getLabel());
        }
        XMLUtils.endElement(contentHandler, CDMFRTagsConstants.TAG_WEB_LINK);
    }
}
