/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.init;

import java.util.HashMap;
import java.util.Map;

import org.ametys.core.util.MapUtils;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentPrioritizableExtensionPoint;

/**
 * The {@link OdfRefTableData} extension point to list all available CSV files to import.
 */
public class OdfRefTableDataExtensionPoint extends AbstractThreadSafeComponentPrioritizableExtensionPoint<OdfRefTableData>
{
    /** Avalon Role */
    public static final String ROLE = OdfRefTableDataExtensionPoint.class.getName();
    
    /**
     * Data to import for all the extension points {@link OdfRefTableData}.
     * If we have the same content type id twice, only the first one is kept. There is a priorization, less is the priority number, more it is prior.
     * @return Path of CSV files to import by content type id.
     */
    public Map<String, String> getDataToImport()
    {
        return getExtensionsIds()
            .stream()
            .map(this::getExtension)
            .map(OdfRefTableData::getDataToImport)
            .reduce(new HashMap<>(), MapUtils::merge);
    }
}
