/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation;

import org.ametys.odf.ProgramItem;

/**
 * Observation constants specific to ODF.
 */
public interface OdfObservationConstants
{
    /** Event id sent when a content is translated. */
    public static final String ODF_CONTENT_TRANSLATED = "odf.content.translated";
    
    /** Event id sent when a skills display of content is changed. */
    public static final String ODF_CONTENT_SKILLS_EXCLUSION_CHANGED = "odf.content.skills.exclusion.changed";
    
    /** Argument of skills exclusion for a content. */
    public static final String ODF_CONTENT_SKILLS_EXCLUSION_ARG = "odf.content.skills.exclusion.arg";
    
    /** Event when a educational path does no more exist */
    public static final String EVENT_PROGRAM_ITEM_HIERARCHY_CHANGED = "odf.program.item.hierarchy.changed";
    
    /** Argument for a {@link ProgramItem} */
    public static final String ARGS_PROGRAM_ITEM = "program.item";
    
    /** Argument for id of a {@link ProgramItem} */
    public static final String ARGS_PROGRAM_ITEM_ID = "program.item.id";
    
    /** Argument for a old parent of a {@link ProgramItem} */
    public static final String ARGS_OLD_PARENT_PROGRAM_ITEM_ID = "old.parent.program.item.id";
    
    /** Argument for new parents of a {@link ProgramItem} */
    public static final String ARGS_NEW_PARENT_PROGRAM_ITEM_IDS = "new.parent.program.item.ids";
}
