/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.person;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.ContentFactory;
import org.ametys.cms.repository.ModifiableContentFactory;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * {@link ContentFactory} for handling {@link Person}.
 */
public class PersonFactory extends ModifiableContentFactory
{
    /** {@link Person} nodetype for resources collection */
    public static final String PERSON_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":personContent";

    /** {@link Person} content type */
    public static final String PERSON_CONTENT_TYPE = "org.ametys.plugins.odf.Content.person";
    
    private RootOrgUnitProvider _rootOrgUnitProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) manager.lookup(RootOrgUnitProvider.ROLE);
    }

    @Override
    public Person getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new Person(node, parentPath, this);
    }

    String _getRootOrgUnitRNE()
    {
        return _rootOrgUnitProvider.getRoot().getUAICode();
    }
}
