/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


const rightsToMigrate = 
{
    "ODF_Rights_Educational_Booklet_SubProgram" : "ODF_Rights_Educational_Booklet_Generate",
    "ODF_Rights_Educational_Booklet_SubProgram_Archive" : "ODF_Rights_Educational_Booklet_Archive",
    "ODF_Rights_Educational_Booklet_SubProgram_See" : "ODF_Rights_Educational_Booklet_See",
    "ODF_Rights_Educational_Booklet_SubProgram_Delete" : "ODF_Rights_Educational_Booklet_Delete"
}

const _rightProfileDAO = Ametys.serviceManager.lookup("org.ametys.core.right.RightProfilesDAO");

logger.info("Start migrating of rights related to educational booklet");

let count = 0;
let profiles=_rightProfileDAO.getProfiles()
for(let profile of profiles)
{
    let updated = false;
    let profileRights = _rightProfileDAO.getRights(profile)
    for(let [oldRight, newRight] of Object.entries(rightsToMigrate))
    {
      if (profileRights.contains(oldRight))
      {
          _rightProfileDAO.removeRight(profile, oldRight, true);
          _rightProfileDAO.addRight(profile, newRight);
          
          updated = true;
      }
    }
    if (updated)
        count++;
}

logger.info(`${count} profile(s) have been updated`);
