<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 							  xmlns:exsl="http://exslt.org/common"
 							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
 							  xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                              xmlns:odf="org.ametys.odf.OdfXSLTHelper"
 							  xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="program.xsl"/>
	<xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>

	<xsl:variable name="common-content-css-class-name">program view-main</xsl:variable>    
	
    <xsl:variable name="programAnchor" select="translate($programId, ':/', '')"/>
	
	<!-- +
	     | ENTRY POINT FROM THE COMMON.XSL
	     + -->
	<xsl:template name="common-content-body-content">
		<!-- compute the level for titles h1 or h2
		     this depends if the template 'common-content-body-title-content' is empty or not -->   
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content"/>
        </xsl:variable>
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>     
    
    	<!-- Divide the rendering into two colomns -->
        <div class="col-content">
            <xsl:call-template name="brief">
            	<xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            
            <xsl:call-template name="tabs">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
        </div> 
                
        <div class="col-right">
            <xsl:call-template name="right-content">
                <xsl:with-param name="truelevel" select="$truelevel"/>            
            </xsl:call-template>
        </div>  
        <div class="col-end"/>        
    </xsl:template>    
    
    <xsl:template name="translations">
    	<xsl:if test="translations/*">
	    	<div class="translations">
	    		<ul>
				<xsl:for-each select="translations/*">
					<li>
						<xsl:attribute name="class">
							<xsl:if test="position() = 1"><xsl:text>first </xsl:text></xsl:if>
							<xsl:if test="position() = last()"><xsl:text>last </xsl:text></xsl:if>
							<xsl:text>translation-</xsl:text><xsl:value-of select="local-name()"/>
						</xsl:attribute>
						
						<a href="{resolver:resolve('odf', .)}">
						    <xsl:value-of select="local-name()"/>
                        </a>
					</li>
				</xsl:for-each>
				</ul>
			</div>
		</xsl:if>
    </xsl:template>

    <xsl:template name="right-content">
        <xsl:param name="truelevel"/>
    
        <xsl:call-template name="orgunit">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="infos">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="more-info">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="partner-laboratories">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="partner-schools">
            <xsl:with-param name="truelevel" select="$truelevel"/>        
        </xsl:call-template>
        
        <!-- Autre(s) structure(s) partenaire(s) -->
        <xsl:call-template name="common-content-richtext-field">
            <xsl:with-param name="value" select="metadata/otherPartners"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'PLUGINS_ODF_PROGRAM_OTHER_PARTNERS'"/>
        </xsl:call-template>  
        
        <xsl:call-template name="download">
            <xsl:with-param name="truelevel" select="$truelevel"/>        
        </xsl:call-template>
    </xsl:template>

	
    <!-- + 
         | BLOC Brief 
         + -->    
    <xsl:template name="brief">
    	<xsl:param name="truelevel"/>
        <div class="brief">
        	<xsl:call-template name="translations"/>
        	
        	<xsl:element name="h{$truelevel}"><i18n:text i18n:key="CONTENT_PROGRAM_BRIEF_TITLE" i18n:catalogue="plugin.odf"/></xsl:element>
        	
        	<ul class="custom">
        		<!-- Type de diplôme -->
        		<xsl:if test="normalize-space(metadata/degree/@title ) != ''">
        			<li><strong><i18n:text i18n:key="CONTENT_PROGRAM_DEGREE" i18n:catalogue="plugin.odf"/>: </strong><xsl:value-of select="metadata/degree/@title"/></li>
        		</xsl:if>
        		
        		<!-- Domaine -->
        		<xsl:if test="normalize-space(metadata/domain/@title ) != ''">
        			<li><strong><i18n:text i18n:key="CONTENT_PROGRAM_DOMAIN" i18n:catalogue="plugin.odf"/>: </strong>
        			<xsl:for-each select="metadata/domain">
        				<xsl:value-of select="@title"/><xsl:if test="position() != last()">,</xsl:if>
        			</xsl:for-each>
        			</li>
        		</xsl:if>
        		
        		<!-- Mention -->
        		<xsl:if test="normalize-space(metadata/mention/@title ) != ''">
        			<li><strong><i18n:text i18n:key="CONTENT_PROGRAM_MENTION" i18n:catalogue="plugin.odf"/>: </strong><xsl:value-of select="metadata/mention/@title"/></li>
        		</xsl:if>
        		
        		 <!-- Spécialité -->
        		<xsl:if test="normalize-space(metadata/speciality ) != ''">
        			<li><strong><i18n:text i18n:key="CONTENT_PROGRAM_SPECIALITY" i18n:catalogue="plugin.odf"/>: </strong><xsl:value-of select="metadata/speciality"/></li>
        		</xsl:if>
        	</ul>
        </div>        
    </xsl:template>   
    

	<xsl:template name="tabs">
        <xsl:param name="truelevel"/>
        
        <xsl:variable name="tabs">
            <!-- Tab 01 : Présentation -->
            <xsl:call-template name="tab-01">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <!-- Tab 02 : Organisation -->
            <xsl:call-template name="tab-02">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <!-- Tab 03 : Programme -->
            <xsl:call-template name="tab-03">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <!-- Tab 04 : Admission -->
            <xsl:call-template name="tab-04">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <!-- Tab 05 : Et après (débouchés et poursuites) -->
            <xsl:call-template name="tab-05">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <!-- Tab 06 : Contacts -->
            <xsl:call-template name="tab-06">
                <xsl:with-param name="truelevel" select="$truelevel"/>            
            </xsl:call-template>
        </xsl:variable>
    
        <div id="tabs-{$programAnchor}" class="tabs">
            <ul>
                <xsl:for-each select="exsl:node-set($tabs)/div">
                    <li>
                        <a href="#{@id}"><xsl:copy-of select="node()[1]/node()"/></a>
                    </li> 
                </xsl:for-each>
            </ul>
        
            <xsl:copy-of select="$tabs"/>
        </div>
	</xsl:template>
 
 
	<!-- + 
	     | TAB 1 : Presentation 
	     + -->
	<xsl:template name="tab-01">   
        <xsl:param name="truelevel"/>

		<xsl:variable name="content">
            <!-- Présentation -->
             <xsl:call-template name="common-content-richtext-field">
                 <xsl:with-param name="value" select="metadata/presentation"/>
                 <xsl:with-param name="level" select="$truelevel + 1"/>
                 <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_PRESENTATION'"/>
             </xsl:call-template>            

            <!-- Objectifs -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/objectives"/>
                <xsl:with-param name="level" select="$truelevel + 1 "/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_OBJECTIVES'"/>
            </xsl:call-template>            
			
            <!-- Savoir-faire et compétences -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/qualification"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_QUALIFICATION'"/>
            </xsl:call-template>            
            
           <!-- Formation internationale et Dimension internationale -->
            <xsl:if test="metadata/internationalEducation[@title] or metadata/internationalDimension">
	            <xsl:if test="metadata/internationalEducation[@title]">
		          <xsl:element name="h{$truelevel + 1 }"><i18n:text i18n:key="CONTENT_PROGRAM_INTERNATIONAL_DIMENSION" i18n:catalogue="plugin.odf"/></xsl:element>
		            <xsl:for-each select="metadata/internationalEducation">
		            	<xsl:if test="position() > 1">
							<xsl:text>, </xsl:text>
		            	</xsl:if>
		            	<xsl:value-of select="@title"/>
		            </xsl:for-each>
	            </xsl:if>

	            <xsl:call-template name="common-content-richtext-field">
	                <xsl:with-param name="value" select="metadata/internationalDimension"/>
	                <xsl:with-param name="level" select="$truelevel + 2 "/>
	            </xsl:call-template>
            </xsl:if>	        
	        
	        <!-- Les + de la formation -->
             <xsl:call-template name="common-content-richtext-field">
                 <xsl:with-param name="value" select="metadata/additionalInformations"/>
                 <xsl:with-param name="level" select="$truelevel + 1"/>
                 <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_ADDITIONAL_INFORMATIONS'"/>
             </xsl:call-template> 
             
             <!-- Témoignage(s) -->
            <xsl:if test="metadata/testimonies/entry/text">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TESTIMONIES"/></xsl:element>
                
                <xsl:for-each select="metadata/testimonies/entry">
                	<xsl:if test="image">	
						<div class="content-illustration small">
		                	<img src="{resolver:resolveBoundedImage(image/@type, image/@path, '100', '100')}" alt=""/>
		            	</div>	       			
					</xsl:if>
                	<xsl:if test="normalize-space(title ) != ''">
	                	<xsl:element name="h{$truelevel + 2}"><xsl:value-of select="title"/></xsl:element>
    	       	 	</xsl:if>
    	       	 	<xsl:call-template name="common-content-richtext-field">
		                 <xsl:with-param name="value" select="text"/>
		                 <xsl:with-param name="level" select="$truelevel + 2"/>
		             </xsl:call-template> 
				</xsl:for-each>
            </xsl:if>
            
            <!-- Capacité d'accueil -->
            <xsl:call-template name="common-content-richtext-field">
               <xsl:with-param name="value" select="metadata/numberOfStudents"/>
               <xsl:with-param name="level" select="$truelevel + 1"/>
               <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_TOTAL_STUDENTS'"/>
            </xsl:call-template>
		</xsl:variable>
    
    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-1">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB01_TITLE"/></xsl:element>
	            
	            <xsl:copy-of select="$content"/>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- + 
	     | TAB 2 : Organisation
	     + -->
	<xsl:template name="tab-02">
        <xsl:param name="truelevel"/>
    
		<xsl:variable name="content">
            <!-- Contenu de la formation -->                        
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/teachingOrganization"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_TEACHING_ORGANIZATION'"/>
            </xsl:call-template>            

            <!-- Contrôle des connaissances -->                        
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/knowledgeCheck"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_KNOWLEDGE_CHECK'"/>
            </xsl:call-template>            
            
            <!-- Aménagements particuliers -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/universalAdjustment"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_UNIVERSAL_ADJUSTMENT'"/>
            </xsl:call-template>
            
           <!-- Alternance -->
			<xsl:if test="metadata/apprenticeshipOpen = 'true'">
				<xsl:element name="h{$truelevel + 1}">
            		<i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="plugin.odf"/>
    	        </xsl:element>
    	        
    	        <xsl:if test="normalize-space(metadata/apprenticeshipContract/@title ) != ''">
   	        		<p><em><i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_CONTRACT_KIND" i18n:catalogue="plugin.odf"/> : </em>
		            <xsl:for-each select="metadata/apprenticeshipContract">
		            	<xsl:if test="position() > 1"><xsl:text>, </xsl:text></xsl:if>
		            	<xsl:value-of select="@title"/>
		            </xsl:for-each>
   	        		</p>
		        </xsl:if>
                
                <!-- Rythme d'alternance -->
                <xsl:call-template name="common-content-richtext-field">
                     <xsl:with-param name="value" select="metadata/apprenticeshipPeriod"/>
                     <xsl:with-param name="level" select="$truelevel + 1"/>
                 </xsl:call-template>   
                
                <!-- Modalités d'alternance -->
                <xsl:call-template name="common-content-richtext-field">
                     <xsl:with-param name="value" select="metadata/apprenticeshipModalities"/>
                     <xsl:with-param name="level" select="$truelevel + 1"/>
                 </xsl:call-template>   
			</xsl:if>
			
			<!-- Stages -->
			<xsl:if test="metadata/internshipOpen = 'true'">
				<xsl:element name="h{$truelevel + 1}">
            		<i18n:text i18n:key="CONTENT_PROGRAM_TRAINING_STRATEGY" i18n:catalogue="plugin.odf"/>
    	        </xsl:element>
				
				<xsl:if test="metadata/internship">
					<p class="internship">
						<span class="element-name">
							<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP"/>
						</span>
						<xsl:text> </xsl:text>
						<span class="element-value">
							<xsl:value-of select="metadata/internship/@title"/>
							<xsl:if test="normalize-space(metadata/internshipDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipDuration"/><xsl:text>)</xsl:text></xsl:if>
						</span>
					</p>
				</xsl:if>
				<xsl:if test="metadata/internshipAbroad">
					<p class="intership-abroad">
						<span class="element-name">
							<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP_ABROAD"/>
						</span>
						<xsl:text> </xsl:text>
	   					<span class="element-value">
	   						<xsl:value-of select="metadata/internshipAbroad/@title"/>
	   						<xsl:if test="normalize-space(metadata/internshipAbroadDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipAbroadDuration"/><xsl:text>)</xsl:text></xsl:if>
						</span>
					</p>
				</xsl:if>
				
				<!-- stages -->
	            <xsl:call-template name="common-content-richtext-field">
	                <xsl:with-param name="value" select="metadata/trainingStrategy"/>
	                <xsl:with-param name="level" select="$truelevel + 1"/>
	            </xsl:call-template> 
				
				<xsl:if test="metadata/internshipDescription/entry">
    	        <xsl:for-each select="metadata/internshipDescription/entry">
    	        	<p>
    	        	<strong><xsl:value-of select="title"/></strong>
    	        	</p>
    	        	<ul class="custom">
    	        		<xsl:if test="duration">
    	        			<li>
    	        				<i18n:text i18n:key="PLUGINS_ODF_PROGRAM_INTERNSHIPS_DESCRIPTION_DURATION" i18n:catalogue="plugin.odf"/><xsl:text>: </xsl:text>
    	        				<xsl:value-of select="duration"/><xsl:text> </xsl:text>
    	        			</li>
    	        		</xsl:if>
    	        		<xsl:if test="period">
    	        			<li>
    	        				<i18n:text i18n:key="PLUGINS_ODF_PROGRAM_INTERNSHIPS_DESCRIPTION_PERIOD" i18n:catalogue="plugin.odf"/><xsl:text>: </xsl:text>
    	        				<xsl:value-of select="period"/>
    	        			</li>
    	        		</xsl:if>
    	        		<xsl:if test="kind">
   	        				<li><i18n:text i18n:key="PLUGINS_ODF_PROGRAM_INTERNSHIPS_DESCRIPTION_KIND" i18n:catalogue="plugin.odf"/><xsl:text>: </xsl:text>
   	        				<xsl:call-template name="common-content-richtext-field">
				                <xsl:with-param name="value" select="kind"/>
				                <xsl:with-param name="level" select="$truelevel + 1"/>
				            </xsl:call-template> 
				            </li>
    	        		</xsl:if>
    	        	</ul>
    	        	<br/>
    	        </xsl:for-each>
    	        </xsl:if>            
             </xsl:if> 
             
        </xsl:variable>                         

    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-2">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB02_TITLE"/></xsl:element>
	            
	            <xsl:copy-of select="$content"/>
			</div>
		</xsl:if>
	</xsl:template>

	<!-- + 
	     | TAB 3 : Programme
	     + -->
	<xsl:template name="tab-03">
        <xsl:param name="truelevel"/>
    
		<xsl:variable name="content">

            <!-- Organisation de la formation -->
           <xsl:if test="subprogram|container|courseList">
	            <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PROGRAM_TITLE"/></xsl:element>
	            
	            <ul class="custom">
	            	<xsl:apply-templates select="subprogram|container|courseList"/>
	            </ul>
		 </xsl:if>
         
        </xsl:variable>                         

    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-3">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB03_TITLE"/></xsl:element>
	
	            <xsl:copy-of select="$content"/>
	        </div>
		</xsl:if>
	</xsl:template>

	<!-- + 
	     | TAB 4 : Admission 
	     + -->
    <xsl:template name="tab-04">
        <xsl:param name="truelevel"/>
    
		<xsl:variable name="content">
            <!-- Condition d'accès -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/accessCondition"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_ACCESS_CONDITION'"/>
            </xsl:call-template>            
            
            <!-- inscription -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/inscription"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_INSCRIPTION'"/>
            </xsl:call-template>     
            
            <!-- Public cible -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/targetGroup"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_TARGET_GROUP'"/>
            </xsl:call-template>            
            
            <!-- Droits de scolarité -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/expenses"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_EXPENSES'"/>
            </xsl:call-template>            
                        
            <!-- Pré requis nécessaires -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/neededPrerequisite"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_NEEDED_PREREQUISITE'"/>
            </xsl:call-template>            
            
            <!-- Pré requis recommandés -->                        
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/recommendedPrerequisite"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_RECOMMENDED_PREREQUISITE'"/>
            </xsl:call-template>            
		</xsl:variable>

    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-4">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB04_TITLE"/></xsl:element>
	
	            <xsl:copy-of select="$content"/>
	        </div>
	    </xsl:if>
    </xsl:template>
	    
    <!-- + 
         | TAB 5 : Et après
         + -->         
    <xsl:template name="tab-05">
        <xsl:param name="truelevel"/>
    
		<xsl:variable name="content">
            <!-- Poursuite d'études -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/furtherStudy"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_FURTHER_STUDY'"/>
            </xsl:call-template>            
                        
            <!-- Poursuite d'études à l'étranger -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/studyAbroad"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_STUDY_ABROAD'"/>
            </xsl:call-template>            
            
            <!-- Insertion professionnelle -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/jobOpportunities"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_JOB_OPPORTUNITIES'"/>
            </xsl:call-template>            
            
            <!-- Secteurs -->
            <xsl:if test="normalize-space(metadata/sectors/@title ) != ''">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_SECTORS"/></xsl:element>
                <ul>
                	<xsl:for-each select="metadata/sectors">
                		<li><xsl:value-of select="@title"/></li>
                	</xsl:for-each>
                </ul>
            </xsl:if>  
            
            <!-- Passerelles et ré orientation -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/reorientation"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_PROGRAM_REORIENTATION'"/>
            </xsl:call-template>  
            
	        <!-- Référenciels ROME -->
            <xsl:if test="metadata/romeCode">
	            <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_ROME_TITLE"/></xsl:element>
	            <ul class="custom">
		            <xsl:for-each select="metadata/romeCode">
		            	<li><xsl:value-of select="concat(odf:getCode(@id), ': ', @title)"/></li>
		            </xsl:for-each>    
		        </ul>  
	        </xsl:if>     
		</xsl:variable>
		
    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-5">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB05_TITLE"/></xsl:element>  
            
	            <xsl:copy-of select="$content"/>
	        </div>
		</xsl:if>
    </xsl:template>    
    
    <!-- + 
         | TAB 6 : Contact
         + -->         
    <xsl:template name="tab-06">
        <xsl:param name="truelevel"/>
    
		<xsl:variable name="content">
            <!-- Composante -->
            <xsl:if test="metadata/orgUnit">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_ORGUNIT"/></xsl:element>
                <xsl:for-each select="metadata/orgUnit">
                    <xsl:variable name="orgUnitId" select="@id"/>
                    <xsl:apply-templates select="//content/orgunits/content[@id = $orgUnitId]/html/body/node()" mode="move-hierarchy">
                        <xsl:with-param name="level" select="$truelevel + 2"/>
                    </xsl:apply-templates>   
                </xsl:for-each>            
            </xsl:if>
            
            <!-- Lieu de la formation -->
            <xsl:if test="metadata/place">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PLACE"/></xsl:element>
                <ul>
                	<xsl:for-each select="metadata/place">
                		<li><xsl:value-of select="@title"/></li>
                	</xsl:for-each>
                </ul>
            </xsl:if>
             <!-- Campus -->
            <xsl:if test="normalize-space(metadata/campus) != ''">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_CAMPUS"/></xsl:element>
                <ul>
                	<xsl:for-each select="metadata/campus">
                		<li><xsl:value-of select="@title"/></li>
                	</xsl:for-each>
                </ul>
            </xsl:if>
            
            <!-- Contact(s) -->
            <xsl:if test="metadata/contacts/entry/persons">
            
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_PROGRAM_CONTACTS"/></xsl:element>
                
                <xsl:for-each select="metadata/contacts/entry">
                	<xsl:choose>
                		<xsl:when test="normalize-space(role/@title) != ''">
                			<xsl:element name="h{$truelevel + 2}"><xsl:value-of select="role/@title"/></xsl:element>
                			<xsl:for-each select="persons">
                				<xsl:variable name="personId" select="@id"/>
			                	<xsl:apply-templates select="//content/persons/content[@id = $personId]/html/body/node()" mode="move-hierarchy">
			                    	<xsl:with-param name="level" select="$truelevel + 3"/>
			                	</xsl:apply-templates>
		                	</xsl:for-each>
                		</xsl:when>
                		<xsl:otherwise>
                			<xsl:for-each select="persons">
                				<xsl:variable name="personId" select="@id"/>
			                	<xsl:apply-templates select="//content/persons/content[@id = $personId]/html/body/node()" mode="move-hierarchy">
			                    	<xsl:with-param name="level" select="$truelevel + 2"/>
			                	</xsl:apply-templates>
		                	</xsl:for-each>
                		</xsl:otherwise>
                	</xsl:choose>
				</xsl:for-each>
            </xsl:if>

             <!-- Autres Contacts-->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/otherContact"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
                <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_PROGRAM_OTHER_CONTACT'"/>
            </xsl:call-template> 
		</xsl:variable>
		
    	<xsl:if test="exsl:node-set($content)/node()">
	        <div id="{$programAnchor}-6">
	            <xsl:element name="h{$truelevel}"><xsl:attribute name="class">tab-title</xsl:attribute><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TAB06_TITLE"/></xsl:element>    
        
	            <xsl:copy-of select="$content"/>
	        </div>
		</xsl:if>
    </xsl:template>    
	
	<!-- +
	     | RIGHT CONTENT : Infos
	     + -->
	<xsl:template name="infos">
        <xsl:param name="truelevel"/>
    
        <xsl:variable name="content">
            <!-- Nombre de crédits ECTS -->
            <xsl:call-template name="ects"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>

            <!-- Durée -->
            <xsl:call-template name="duration"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>

            <!-- Niveau d'étude -->
            <xsl:call-template name="educationLevel"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>

            <!-- Public concerné (formation initiale, continue, ...) -->
            <xsl:call-template name="education-public"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Formation à distance -->
            <xsl:call-template name="distanceLearning"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
                
            <!-- Nature de la formation -->
            <xsl:call-template name="educationKind"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Certifications possibles -->
            <xsl:call-template name="availableCertification"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Langue d'enseignement -->
            <xsl:call-template name="educationLanguage"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Stage -->
            <xsl:call-template name="internship"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template> 
            
            <!-- Stage à l'étranger -->
            <xsl:call-template name="internshipAbroad"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Inscriptions -->
            <xsl:call-template name="registration"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Début de la formation -->
            <xsl:call-template name="teachingStart"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Fin de la formation -->
            <xsl:call-template name="teachingEnd"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
            
            <!-- Taux de réussite -->
            <xsl:call-template name="successRate"><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($content)/node()">
    		<div class="bloc more-info">
    			<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_MORE_INFO"/></xsl:element>
    			<xsl:copy-of select="$content"/>
    		</div>
         </xsl:if>
         
        <!-- Blocs de compétences acquis -->
        <xsl:call-template name="acquiredSkills" ><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
         
	</xsl:template>

    <!-- Blocs de compétences acquis -->
    <xsl:template name="acquiredSkills">
        <xsl:param name="trueLevel"/>
        
        <xsl:if test="/view/skills/skillSet">
             <div class="bloc acquired-skills">
                 <xsl:element name="h{$trueLevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_ACQUIRED_SKILLS_LABEL"/></xsl:element>
                 <xsl:for-each select="/view/skills/skillSet">
                      <p><span class="element-name"><xsl:value-of select="@title" /></span></p>
                      <xsl:if test="count(skill) > 0">
                          <ul class="custom">
                               <xsl:for-each select="skill">
                                    <li><xsl:value-of select="@title" /></li>            
                                  </xsl:for-each>
                          </ul>
                      </xsl:if>
                 </xsl:for-each>
             </div>    
         </xsl:if>
    </xsl:template>

    <!-- Certifications possibles -->
	<xsl:template name="availableCertification">
        <xsl:param name="truelevel"/>

            <xsl:if test="metadata/availableCertification">
    			<p class="availableCertification">
    				<span class="element-name"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_LEVEL"/></span>
   					<ul class="custom">
   						<xsl:for-each select="metadata/availableCertification">
							<li><xsl:value-of select="@title"/></li>			
						</xsl:for-each>
   					</ul>
    			</p>
            </xsl:if>
	</xsl:template>
	
    <!-- Niveau d'étude -->
	<xsl:template name="educationLevel">
        <xsl:param name="truelevel"/>

            <xsl:if test="metadata/educationLevel">
    			<p class="education-level">
    				<span class="element-name">
    					<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_LEVEL"/>
    				</span><br/>
   					<span class="element-value"><xsl:value-of select="metadata/educationLevel/@title"/></span>
    			</p>
            </xsl:if>
	</xsl:template>
	
	<!-- Organisation de la formation / public cible. -->
	<xsl:template name="education-public">
        <xsl:param name="truelevel"/>
        
        <xsl:if test="metadata/formofteachingOrg">
            <p class="public"><span class="element-name"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_EDUCATION_TYPE"/></span></p>
            <ul class="custom">
                <xsl:for-each select="metadata/formofteachingOrg">
                    <li><xsl:value-of select="@title"/></li>
                </xsl:for-each>
            </ul>
        </xsl:if>
	</xsl:template>
	
    <!-- Nature de la formation -->
	<xsl:template name="educationKind">
        <xsl:param name="truelevel"/>

            <xsl:if test="metadata/educationKind">
                <p class="education-kind">
    				<span class="element-name">
    					<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_EDUCATION_KIND"/>
    				</span>
 					<br/>
   					<span class="element-value"> <xsl:value-of select="metadata/educationKind/@title"/></span>
                </p>            
            </xsl:if>
	</xsl:template>
	
    <!-- Formation à distance -->
	<xsl:template name="distanceLearning">
        <xsl:param name="truelevel"/>

			<xsl:if test="metadata/distanceLearning">
    			<p class="distance-learning">
    				<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_DISTANCE_LEARNING"/>
    				</span>
					<xsl:text> </xsl:text>
					<span class="element-value"> <xsl:value-of select="metadata/distanceLearning/@title"/></span>
    			</p>
            </xsl:if>
	</xsl:template>
	
	<!-- Durée -->
	<xsl:template name="duration">
        <xsl:param name="truelevel"/>

			<xsl:if test="normalize-space(metadata/duration/@title) != ''">
                <p class="duration">
    				<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_DURATION"/>
    				</span>
    				<xsl:text> </xsl:text>
    				<span class="element-value"><xsl:value-of select="metadata/duration/@title"/></span> 				
                </p>            
            </xsl:if>
	</xsl:template>
	
    <!-- Langue d'enseignement -->
	<xsl:template name="educationLanguage">
        <xsl:param name="truelevel"/>

            <xsl:if test="normalize-space(metadata/educationLanguage/@title) != ''">
                <p class="education-language">
                	<span class="element-name">
                		<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_EDUCATION_LANGUAGE"/>
    				</span>
    				<xsl:text> </xsl:text>
    				<span class="element-value"> 
    					<xsl:for-each select="metadata/educationLanguage">
							<xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>			
						</xsl:for-each>
					</span> 				
	            </p>
            </xsl:if>
	</xsl:template>
	
    <!-- Nombre de crédits ECTS -->
	<xsl:template name="ects">
        <xsl:param name="truelevel"/>

            <xsl:if test="normalize-space(metadata/ects/@title) != ''">
    			<p class="ects">
		            <span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_ECTS"/>
    				</span>
					<xsl:text> </xsl:text>
   					<span class="element-value"><xsl:value-of select="metadata/ects/@title"/></span>
    			</p>
            </xsl:if>
	</xsl:template>

    <!-- Stage -->
	<xsl:template name="internship">
        <xsl:param name="truelevel"/>

			<xsl:if test="metadata/internship">
				<p class="internship">
					<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP"/>
					</span>
					<xsl:text> </xsl:text>
					<span class="element-value">
						<xsl:value-of select="metadata/internship/@title"/>
						<xsl:if test="normalize-space(metadata/internshipDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipDuration"/><xsl:text>)</xsl:text></xsl:if>
					</span>
				</p>
			</xsl:if>
	</xsl:template>
	
    <!-- Stage à l'étranger -->
	<xsl:template name="internshipAbroad">
        <xsl:param name="truelevel"/>

			<xsl:if test="metadata/internshipAbroad">
				<p class="intership-abroad">
					<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_INTERNSHIP_ABROAD"/>
					</span>
					<xsl:text> </xsl:text>
   					<span class="element-value">
   						<xsl:value-of select="metadata/internshipAbroad/@title"/>
   						<xsl:if test="normalize-space(metadata/internshipAbroadDuration) != ''"><xsl:text> (</xsl:text><xsl:value-of select="metadata/internshipAbroadDuration"/><xsl:text>)</xsl:text></xsl:if>
					</span>
				</p>
			</xsl:if>
	</xsl:template>
	
    <!-- Inscriptions -->
	<xsl:template name="registration">
        <xsl:param name="truelevel"/>
        
		<xsl:if test="normalize-space(metadata/registrationStart) != '' or normalize-space(metadata/registrationDeadline) != ''">
			<p class="registration-start">
				<span class="element-name">
					<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_REGISTRATION"/>
				</span>
				<br/>
				<span class="element-value">
                    <xsl:choose>
                        <xsl:when test="normalize-space(metadata/registrationStart) != '' and normalize-space(metadata/registrationDeadline) != ''">
                            <i18n:translate>
                                <i18n:text i18n:key="CONTENT_PROGRAM_REGISTRATION_FROM_TO"/>
                                <i18n:param name="start"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/registrationStart}"/></i18n:param>
                                <i18n:param name="end"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/registrationDeadline}"/></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                        <xsl:when test="normalize-space(metadata/registrationStart) != ''">
                            <i18n:translate>
                                <i18n:text i18n:key="CONTENT_PROGRAM_REGISTRATION_FROM"/>
                                <i18n:param name="start"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/registrationStart}"/></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                        <xsl:when test="normalize-space(metadata/registrationDeadline) != ''">
                            <i18n:translate>
                                <i18n:text i18n:key="CONTENT_PROGRAM_REGISTRATION_TO"/>
                                <i18n:param name="end"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/registrationDeadline}"/></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                    </xsl:choose>
				</span>
			</p>
		</xsl:if>
	</xsl:template>
	
    <!-- Début de la formation -->
	<xsl:template name="teachingStart">
        <xsl:param name="truelevel"/>

		<xsl:if test="normalize-space(metadata/teachingStart) != ''">
			<p class="teaching-start">
				<span class="element-name">
					<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TEACHING_START"/>
				</span>
				<br/>
				<span class="element-value">
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/teachingStart}"/>
				</span>
			</p>
		</xsl:if>
	</xsl:template>
    
     <!-- Fin de la formation -->
    <xsl:template name="teachingEnd">
        <xsl:param name="truelevel"/>

        <xsl:if test="normalize-space(metadata/teachingEnd) != ''">
            <p class="teaching-end">
                <span class="element-name">
                    <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_TEACHING_END"/>
                </span>
                <br/>
                <span class="element-value">
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSS" pattern="long" value="{metadata/teachingEnd}"/>
                </span>
            </p>
        </xsl:if>
    </xsl:template>
	
    <!-- Taux de réussite -->
	<xsl:template name="successRate">
        <xsl:param name="truelevel"/>

			<xsl:if test="normalize-space(metadata/successRate) != ''">
				<p class="success-rate">
					<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_SUCCESS_RATE"/>
					</span>
					<xsl:text> </xsl:text>
   					<span class="element-value"><xsl:value-of select="metadata/successRate"/></span>
				</p>
			</xsl:if>
	</xsl:template>
	
    <!-- +
         | RIGHT CONTENT : Etablissement
         + -->
    <xsl:template name="orgunit">
        <xsl:param name="truelevel"/>
        <xsl:if test="metadata/jointOrgUnit">
            <div class="bloc joint-orgunit">
                <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_JOINT_ORGUNIT"/></xsl:element>
                <ul>
                   <xsl:for-each select="metadata/jointOrgUnit">
                       <li><xsl:value-of select="@title"/></li>
                   </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>    
    
	<!-- +
	     | RIGHT CONTENT : En savoir plus (site du diplome)
	     + -->
	<xsl:template name="more-info">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/programWebSite/entry">
    		<div class="bloc knowmore">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_WEB_LINK_TITLE"/></xsl:element>
				<p>
	    		<xsl:for-each select="metadata/programWebSite/entry">
	    			<a href="{programWebSiteUrl}">
                        <xsl:choose>
                            <xsl:when test="normalize-space(programWebSiteLabel) != ''"><xsl:value-of select="programWebSiteLabel"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="programWebSiteUrl"/></xsl:otherwise>
                        </xsl:choose>                
                    </a>  
	    		</xsl:for-each>
	    		</p>
	    	</div>
    	</xsl:if>		
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Laboratoires partenaires
	     + -->
	<xsl:template name="partner-laboratories">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/partnerLaboratories/entry/*">
			<div class="bloc partner-labs">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PARTNER_LABORATORIES"/></xsl:element>
				
				<xsl:if test="metadata/partnerLaboratories/entry">
					<ul class="custom">
						<xsl:for-each select="metadata/partnerLaboratories/entry">
							<li><a title="{linkLabel}" href="{linkUrl}" onclick="window.open(this.href); return false;"><xsl:value-of select="linkLabel"/></a></li>
						</xsl:for-each>
					</ul>
				</xsl:if>
			</div>
		</xsl:if>	
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Etablissements partenaires
	     + -->
	<xsl:template name="partner-schools">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/partnerSchools/entry/*">
			<div class="bloc partners-schools">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_PARTNER_SCHOOLS"/></xsl:element>
				<xsl:if test="metadata/partnerSchools/entry">
					<ul class="custom">
						<xsl:for-each select="metadata/partnerSchools/entry">
							<li><a title="{linkLabel}" href="{linkUrl}"><xsl:value-of select="linkLabel"/></a></li>
						</xsl:for-each>
					</ul>
				</xsl:if>
			</div>
		</xsl:if>	
	</xsl:template>
	
    <!-- +
         | RIGHT CONTENT : A télécharger
         + -->    
	<xsl:template name="download">
        <xsl:param name="truelevel"/>
    
		<xsl:if test="metadata/attachments/entry/attachment">
			<div class="bloc download">
                <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_PROGRAM_ATTACHMENT"/></xsl:element>
                
                <xsl:for-each select="metadata/attachments/entry">
	                <p>
	                <span class="file">
		                <a href="{resolver:resolve(attachment/@type, attachment/@path, 'true')}" title="{attachment/@filename} ({attachment/@size})">
							<img class="icon" alt=""><xsl:attribute name="src"><xsl:value-of select="$uri-prefix"/><xsl:text>/plugins/explorer/icon/</xsl:text><xsl:value-of select="filenameutils:getExtension(attachment/@filename)"/><xsl:text>.png</xsl:text></xsl:attribute></img>
		                    <xsl:choose>
		                    	<xsl:when test="normalize-space(attachment-text) != ''"> <xsl:value-of select="attachment-text"/></xsl:when>
		                    	<xsl:otherwise><xsl:value-of select="attachment/@filename"/></xsl:otherwise>
		                    </xsl:choose>
		                </a>
	                	<span class="size"> (<xsl:call-template name="format-size"><xsl:with-param name="size" select="attachment/@size"/></xsl:call-template>)</span>            
	            	</span> 
	            	</p>   
            	</xsl:for-each>
			</div>
		</xsl:if>	
	</xsl:template>
	
	<xsl:template name="format-size">
        <xsl:param name="size"/>
        
        <xsl:choose>
            <xsl:when test="$size &lt; 1024">
                <i18n:translate>
                    <i18n:text i18n:key="CONTENT_PROGRAM_ATTACHMENTS_FILE_SIZE_BYTES"/>
                    <i18n:param><xsl:value-of select="$size"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:when test="$size &lt; (1024 * 1024)">
                <i18n:translate>
                    <i18n:text i18n:key="CONTENT_PROGRAM_ATTACHMENTS_FILE_SIZE_KB"/>
                    <i18n:param><xsl:value-of select="round($size div 1024)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="CONTENT_PROGRAM_ATTACHMENTS_FILE_SIZE_MB"/>
                    <i18n:param><xsl:value-of select="round($size div (1024 * 1024))"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
	<xsl:template match="container">
		<li>
			<xsl:value-of select="@title"/><xsl:if test="@ects != '' and @ects != '0'"> (<xsl:value-of select="@ects"/><xsl:text> </xsl:text><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_CONTAINER_CREDIT_ECTS"/>)</xsl:if>
		
			<xsl:if test="subprogram|courseList|container">
				<ul class="custom">
					<xsl:apply-templates select="subprogram|courseList|container"/>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
	
	<xsl:template match="subprogram">
		<li>
			<a href="{resolver:resolve('odf', concat(@id, ';', /view/content/@id))}"><xsl:value-of select="@title"/></a>
        </li>
	</xsl:template>
	
	<xsl:template match="courseList">
		<xsl:param name="parentCourseId" select="concat(';', /view/content/@id)"/>
		
		<li>
			<strong><xsl:value-of select="@title"/></strong>
			<xsl:if test="@ects != '' and @ects != '0'"> (<xsl:value-of select="@ects"/><xsl:text> </xsl:text><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_ECTS"/>)</xsl:if>
			<xsl:choose>
				<xsl:when test="@type = 'CHOICE'">
                    <br/>
                    <xsl:value-of select="@min"/><xsl:text> </xsl:text>
                    <xsl:if test="@max > 0 and @min != @max">
                        <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_CHOICE_TO"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="@max"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:text> </xsl:text>
                    <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_CHOICE"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="count(course)"/>
				</xsl:when>
				<xsl:when test="@type = 'MANDATORY'"></xsl:when>
				<xsl:when test="@type = 'OPTIONAL'"><br/><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_OPTIONAL"/></xsl:when>
			</xsl:choose>
			
			<xsl:if test="course">
				<ul class="custom">
					<xsl:apply-templates select="course">
						<xsl:with-param name="parentCourseId" select="$parentCourseId"/>
					</xsl:apply-templates>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
	
	<xsl:template match="course">
		<xsl:param name="parentCourseId"/>
		
        <li>
        	<a href="{resolver:resolve('odf', concat(@id, $parentCourseId))}">
        		<xsl:value-of select="@title"/>
        		<xsl:if test="metadata/ects != '' and metadata/ects != '0'"><xsl:text> (</xsl:text><xsl:value-of select="metadata/ects"/><xsl:text> </xsl:text><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_ECTS"/><xsl:text>)</xsl:text></xsl:if>
        	</a>
        	<xsl:if test="courseList/course">
				<ul class="custom">
					<xsl:apply-templates select="courseList">
						<xsl:with-param name="parentCourseId" select="concat (';', @id, $parentCourseId)"></xsl:with-param>
					</xsl:apply-templates>
				</ul>
			</xsl:if>
        </li>
	</xsl:template>
	
</xsl:stylesheet>