/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.courselist;

import javax.jcr.Node;

import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPartFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * Course List Factory for handling Courses
 * 
 */
public class CourseListFactory extends ProgramPartFactory
{
    /** {@link Program} content type */
    public static final String COURSE_LIST_CONTENT_TYPE = "org.ametys.plugins.odf.Content.courseList";
    
    /** {@link CourseList} nodetype for resources collection */
    public static final String COURSE_LIST_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":courseListContent";
    
    @Override
    public CourseList getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new CourseList(node, parentPath, this);
    }

    // FIXME : Ne doit pas être surchargé
    @Override
    public String getScheme()
    {
        return "courseListContent";
    }
}
