<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<!--DOCTYPE xsl:stylesheet PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "xhtml1-transitional.dtd"-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:resolver="org.ametys.odf.export.ExportXSLTHelper"
                xmlns:stringutils="org.apache.commons.lang.StringUtils"
                xmlns:cms="http://ametys.org/cms/3.0" 
                extension-element-prefixes="stringutils cms"
                exclude-result-prefixes="html docbook resolver">
    
    <!-- docbook2html -->
    <xsl:import href="view:cms://stylesheets/io/docbook2html.xsl"/>

    <xsl:template match="/metadata">
        <metadata>
            <xsl:apply-templates/>
        </metadata>
    </xsl:template>
    
    <!-- champ multivalué -->
    <xsl:template match="*[@id and local-name(..) = 'metadata']">
        <xsl:value-of select="@title"/>
        <xsl:if test="position() != last()"><br/></xsl:if>
    </xsl:template>
    
    <xsl:template match="*[local-name(..) = 'metadata']">
        <xsl:value-of select="."/>
        <xsl:if test="position() != last()"><br/></xsl:if>
    </xsl:template>
    
    <xsl:template match="*[docbook:article]">
        <xsl:if test="cms:isNotRichTextEmpty(.)">
            <xsl:apply-templates select="docbook:article"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="image">
       	<xsl:variable name="srcResolved" select="resolver:resolveImage(docbook:imagedata/@type, docbook:imagedata/@fileref, substring-before(docbook:imagedata/@depth, 'px'), substring-before(docbook:imagedata/@width, 'px'))"/>
        <xsl:variable name="srcUpdated" select="stringutils:remove($srcResolved, '/null')"/>
        <xsl:variable name="src">
            <xsl:call-template name="get-image-src">
                <xsl:with-param name="srcResolved" select="$srcUpdated"/>
            </xsl:call-template>
        </xsl:variable>
        
      	<img src="{$src}">
            <xsl:if test="../docbook:alt">
            	<xsl:attribute name="alt"><xsl:value-of select="../docbook:alt"/></xsl:attribute>
            </xsl:if>
            
            <xsl:call-template name="image-title-attribute">
                <xsl:with-param name="srcResolved" select="$srcUpdated"/>
            </xsl:call-template>
            
            <xsl:call-template name="image-style-attribute">
                <xsl:with-param name="srcResolved" select="$srcUpdated"/>
            </xsl:call-template>
            
            <xsl:variable name="width"><xsl:value-of select="substring-before(docbook:imagedata/@width, 'px')" /></xsl:variable>
            <xsl:if test="$width != ''"><xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute></xsl:if>

           	<xsl:variable name="height"><xsl:value-of select="substring-before(docbook:imagedata/@depth, 'px')"/></xsl:variable>
            <xsl:if test="$height != ''"><xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute></xsl:if>

            <xsl:if test="docbook:imagedata/@align"><xsl:attribute name="align"><xsl:value-of select="docbook:imagedata/@align"/></xsl:attribute></xsl:if>
        </img>
	</xsl:template>
</xsl:stylesheet>
