/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.odf.data.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Model of catalog objects
 */
public class CatalogModel implements Model, Serviceable, Initializable, Component
{
    /** Avalon Role */
    public static final String ROLE = CatalogModel.class.getName();
    
    /** title attribute. */
    public static final String TITLE = "title";
    
    /** isDefault attribute. */
    public static final String IS_DEFAULT = "isDefault";
    
    private ModelItemTypeExtensionPoint _catalogDataTypeExtensionPoint;
    private List<ModelItem> _modelItems = new ArrayList<>();

    public void service(ServiceManager manager) throws ServiceException
    {
        _catalogDataTypeExtensionPoint = (ModelItemTypeExtensionPoint) manager.lookup(ModelItemTypeExtensionPoint.ROLE_CATALOG);
    }

    public void initialize() throws Exception
    {
        ElementDefinition<String> title = new DefaultElementDefinition<>();
        title.setName(TITLE);
        title.setType(_catalogDataTypeExtensionPoint.getExtension(ModelItemTypeConstants.STRING_TYPE_ID));
        _modelItems.add(title);
        
        ElementDefinition<Boolean> isDefault = new DefaultElementDefinition<>();
        isDefault.setName(IS_DEFAULT);
        isDefault.setType(_catalogDataTypeExtensionPoint.getExtension(ModelItemTypeConstants.BOOLEAN_TYPE_ID));
        _modelItems.add(isDefault);
    }

    public Collection< ? extends ModelItem> getModelItems()
    {
        return Collections.unmodifiableList(_modelItems);
    }

    public String getId()
    {
        return CatalogModel.class.getName();
    }

    public String getFamilyId()
    {
        return CatalogModel.class.getName();
    }
}
