/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one ore more orgunit.<br>
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_CONTENT.
 */
Ext.define('Ametys.odf.widget.SelectOrgUnit', {
    extend : 'Ametys.cms.form.widget.SelectContent',
    
    xtype: 'edition.select-orgunit',
    
    constructor: function(config)
    {
        config.ouAllowCreation = config.allowCreation || false;   
        
        // Force 'allowCreation' to 'false' to not display the creation button
        // The creation of new orgunit could be done only from orgunits' tree (see Ametys.odf.helper.ChooseOrgUnit)
        config.allowCreation = false; 
        
        this.callParent(arguments);
    },
    
    selectContentsBySearch: function()
    {
        var config = {
            multiple: this.multiple,
            values: this.getValue() || [],
            callback:  Ext.bind(this._selectOrgUnitsCb, this),
            allowCreation: this.ouAllowCreation == true || this.ouAllowCreation == 'true'
        };
            
        Ametys.odf.helper.ChooseOrgUnit.open(config);
    },
    
    /**
     * This function is called after selecting orgunits in the tree.
     * Sets the value of the field.
     * @param {String|String[]} contentIds The identifiers of selected orgunits 
     * @private
     */
    _selectOrgUnitsCb: function (contentIds)
    {
        this.combobox.setValue(contentIds);
    }
});