/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.xslt;

import java.util.Map;

import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.course.Course;

/**
 * DOM layer on structure of {@link Course}.
 */
public class CourseElement extends AbstractODFElement<Course>
{
    /**
     * Constructor.
     * @param course the underlying {@link Course}.
     * @param depth Depth to SAX.
     * @param parent Parent of the element
     * @param odfHelper ODFHelper to resolve children easily
     */
    public CourseElement(Course course, int depth, CourseListElement parent, ODFHelper odfHelper)
    {
        super(course, depth, parent, odfHelper);
    }

    @Override
    public String getTagName()
    {
        return "course";
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> result = super._lookupAttributes();

        result.put("title", new AmetysAttribute("title", "title", null, _object.getTitle(), this));
        result.put("id", new AmetysAttribute("id", "id", null, _object.getId(), this));
        result.put("code", new AmetysAttribute("code", "code", null, _object.getCode(), this));
        result.put("name", new AmetysAttribute("name", "name", null, _object.getName(), this));
        
        String parentPath = _object.getContextPath();
        if (parentPath != null)
        {
            result.put("path", new AmetysAttribute("path", "path", null, parentPath + "/" + _object.getName() + "-" + _object.getCode(), this));
        }
        
        return result;
    }
}
