<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="i18n exsl">
    
    <xsl:import href="view:cms://stylesheets/properties/content/view.xsl"/>
    
    <xsl:template match="/ActionResult">
        <xsl:variable name="groupContent">
            <xsl:apply-templates select="view/elements/*" mode="display"/>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($groupContent)/*">
            <div class="bloc">
                <h1><i18n:text i18n:catalogue="plugin.odf" i18n:key="UITOOL_DETAILS_ODF_MANAGERS"/></h1>
                <xsl:copy-of select="$groupContent"/>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
