/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.coursepart;

import javax.jcr.Node;

import org.ametys.cms.repository.ModifiableContentFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * {@link CoursePartFactory} for handling {@link CoursePart}
 */
public class CoursePartFactory extends ModifiableContentFactory
{
    /** {@link CoursePart} nodetype for resources collection */
    public static final String COURSE_PART_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":coursePartContent";

    /** {@link CoursePart} content type */
    public static final String COURSE_PART_CONTENT_TYPE = "org.ametys.plugins.odf.Content.coursePart";

    @Override
    public CoursePart getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new CoursePart(node, parentPath, this);
    }
}
