/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.oai;

import org.ametys.odf.program.Program;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface for OAI-PMH Sets
 */
public interface OaiSet
{
    /** Avalon Role */
    public static final String ROLE = OaiSet.class.getName();
    
    /**
     * Return the name of the set
     * @return The name of the set. Can't be null.
     */
    public I18nizableText getName();
    
    /**
     * Return the description of the set
     * @return The description of the set, or null if there is no description.
     */
    public I18nizableText getDescription();
    
    /**
     * Retrieve the list of Records associated with this OAI Set
     * @param expression An Expression to filter the list of records during the request
     * @param sortCriteria A sort criteria to sort the result
     * @return The list of Records
     */
    public AmetysObjectIterable<Program> getRecords(Expression expression, SortCriteria sortCriteria);
}
