/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.odf.bean.AbstractExternalAddress;
import org.ametys.odf.cdmfr.CDMFRTagsConstants;

/**
 * Object that represents a website link : URL and label
 */
public class WebsiteLink extends AbstractExternalAddress
{
    /**
     * Constructor
     * @param url URL of the LOM sheet
     * @param label Label of the LOM sheet
     */
    public WebsiteLink(String url, String label)
    {
        super(url, label);
    }

    /**
     * Transform the website to CDM
     * @param contentHandler the content handler to sax into
     * @throws SAXException if an error occurred while saxing
     */
    public void toCDM(ContentHandler contentHandler) throws SAXException
    {
        XMLUtils.startElement(contentHandler, CDMFRTagsConstants.NAMESPACE_CDMFR + CDMFRTagsConstants.TAG_WEB_LINK);
        if (StringUtils.isNotEmpty(getUrl()))
        {
            XMLUtils.createElement(contentHandler, CDMFRTagsConstants.TAG_HREF, getUrl());
        }
        if (StringUtils.isNotEmpty(getLabel()))
        {
            XMLUtils.createElement(contentHandler, CDMFRTagsConstants.NAMESPACE_CDMFR + CDMFRTagsConstants.TAG_LINK_NAME, getLabel());
        }
        XMLUtils.endElement(contentHandler, CDMFRTagsConstants.NAMESPACE_CDMFR + CDMFRTagsConstants.TAG_WEB_LINK);
    }
}
